﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>

#include <nn/result/result_HandlingUtility.h>
#include <nn/tc/tc_PowerState.h>

namespace nn { namespace tc {

nn::os::SystemEventType g_SleepRequiredByHighTemperatureEvent;

void Initialize() NN_NOEXCEPT
{
    nn::os::CreateSystemEvent(&g_SleepRequiredByHighTemperatureEvent, nn::os::EventClearMode_ManualClear, true);
}

void Finalize() NN_NOEXCEPT
{
    nn::os::DestroySystemEvent(&g_SleepRequiredByHighTemperatureEvent);
}

nn::Result GetThermalEvent(nn::os::SystemEventType* pOutSystemEvent, EventTarget eventTarget, nn::os::EventClearMode clearMode) NN_NOEXCEPT
{
    switch ( eventTarget )
    {
    case EventTarget_AbnormalTemperature:
        nn::os::AttachReadableHandleToSystemEvent(pOutSystemEvent,
            nn::os::GetReadableHandleOfSystemEvent(&g_SleepRequiredByHighTemperatureEvent), false, clearMode);
        break;
    default:
        NN_UNEXPECTED_DEFAULT;
    }

    NN_RESULT_SUCCESS;
}

void SignalThermalEvent(EventTarget eventTarget) NN_NOEXCEPT
{
    switch ( eventTarget )
    {
    case EventTarget_AbnormalTemperature:
        nn::os::SignalSystemEvent(&g_SleepRequiredByHighTemperatureEvent);
        break;
    default:
        NN_UNEXPECTED_DEFAULT;
    }
}

}} // namespace nn::tc
