﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>
#include <nn/nn_Log.h>
#include <nn/nn_TimeSpan.h>
#include <nn/init.h>
#include <nn/os.h>
#include <nn/psc.h>
#include <nn/psc/psc_PmControl.h>
#include <nnt/nntest.h>
#include <nnt/base/testBase_Exit.h>
#include <nnt/teamcity/testTeamcity_Logger.h>
#include <nnt/pscUtil/testPsc_Util.h>

TEST( ShutdownSequenceTestLow, Shutdown )
{
    bool wasTimeout = false;

    // Shutdown
    NN_ABORT_UNLESS_RESULT_SUCCESS(nnt::psc::util::TimedExecutePmRequest(
        &wasTimeout, nn::TimeSpan::FromSeconds(3), nn::psc::PmState_ShutdownReady, nn::psc::PmTransitionOrder_ToHigherPowerState
    ));
    EXPECT_FALSE(wasTimeout);

    NN_LOG("--------------------------------------------------------------------------------------------\n"
           "ShutdownReady sequence done.\n"
           "In real use case, the board will be powered off (or power cycled) at this timing.\n"
           "Though system is still running now, you need to restart the system to run any other program.\n"
           "--------------------------------------------------------------------------------------------\n");
}
