﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>
#include <nn/nn_Log.h>
#include <nn/nn_TimeSpan.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/os.h>
#include <nn/psc.h>
#include <nn/psc/psc_PmControl.h>

#include <nnt/pscUtil/testPsc_Util.h>

namespace nnt { namespace psc { namespace util {

nn::Result TimedWaitPmDispatchResult(bool* pOutWasTimedOut, nn::TimeSpan timeout, nn::psc::PmControl* pControl)
{
    if (!pControl->GetEventPointer()->TimedWait(timeout))
    {
        NN_LOG("Dispatch Request Timed Out!\n");
        *pOutWasTimedOut = true;
        pControl->Cancel();
        pControl->GetEventPointer()->Clear(); // Cancel によるシグナルを解除
    }
    else
    {
        *pOutWasTimedOut = false;
        pControl->GetEventPointer()->Clear();
    }

    pControl->PrintModuleInformation();
    return pControl->GetResult();
}

nn::Result TimedExecutePmRequest(bool* pOutWasTimedOut, nn::TimeSpan timeout, nn::psc::PmState pmState, nn::psc::PmTransitionOrder order, nn::psc::PmFlagSet flags) NN_NOEXCEPT
{
    static nn::psc::PmControl  s_PmControl;
    static bool                s_IsPmControlInitialized = false;

    // 初回のみ PSC のコントロールオブジェクトを初期化
    if (!s_IsPmControlInitialized)
    {
        NN_RESULT_DO(s_PmControl.Initialize(nn::os::EventClearMode_AutoClear));
        s_IsPmControlInitialized = true; // XXX: スレッドアンセーフ
    }

    // PSC にリクエストを投げる
    NN_RESULT_DO(s_PmControl.DispatchRequest(pmState, flags, order));

    // 成功時にもモジュール情報をダンプしておく（所要時間解析で有用なので）
    NN_RESULT_DO(TimedWaitPmDispatchResult(pOutWasTimedOut, timeout, &s_PmControl));
    NN_RESULT_SUCCESS;
}

}}} // namespace nnt::psc::util
