﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/TargetConfigs/build_Base.h>
#include <nn/nn_Log.h>

#include <nn/os.h>

#include <nn/pinmux/pinmux.h>

#include <nnt/nntest.h>

#define ADDITIONAL_SLEEP_FOR_AVOIDING_TIMEOUT

namespace
{
const nn::TimeSpan SleepTime = nn::TimeSpan::FromMilliSeconds(5);
}


//-----------------------------------------------------------------------------
// Pinmux ライブラリの基本的なテスト
TEST(PinmuxBasicTest, Input)
{
#if (defined ADDITIONAL_SLEEP_FOR_AVOIDING_TIMEOUT)
    nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(1000LL));
#endif
    nn::pinmux::PinmuxSession uTxSession;
    nn::pinmux::PinmuxSession sTxSession;

    nn::pinmux::Initialize();

    nn::pinmux::OpenSession(&uTxSession, nn::pinmux::AssignablePinGroupName_ExtConUTx);
    nn::pinmux::OpenSession(&sTxSession, nn::pinmux::AssignablePinGroupName_ExtConSTx);

    nn::pinmux::SetPinAssignment(&uTxSession, nn::pinmux::PinAssignment_ExtConTxUart);
    nn::pinmux::SetPinAssignment(&sTxSession, nn::pinmux::PinAssignment_ExtConTxGpio);

    // 念の為 5ms ほど待ってみる。
    nn::os::SleepThread(SleepTime);

    EXPECT_EQ(nn::pinmux::PinAssignment_ExtConTxUart,
              nn::pinmux::GetPinAssignment(&uTxSession));

    EXPECT_EQ(nn::pinmux::PinAssignment_ExtConTxGpio,
              nn::pinmux::GetPinAssignment(&sTxSession));

    nn::pinmux::SetPinAssignment(&uTxSession, nn::pinmux::PinAssignment_ExtConTxGpio);
    nn::pinmux::SetPinAssignment(&sTxSession, nn::pinmux::PinAssignment_ExtConTxUart);

    // 念の為 5ms ほど待ってみる。
    nn::os::SleepThread(SleepTime);

    EXPECT_EQ(nn::pinmux::PinAssignment_ExtConTxGpio,
              nn::pinmux::GetPinAssignment(&uTxSession));

    EXPECT_EQ(nn::pinmux::PinAssignment_ExtConTxUart,
              nn::pinmux::GetPinAssignment(&sTxSession));

    nn::pinmux::Finalize();
}
