﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Log.h>

#include <nn/os.h>

#include <nn/apm/apm.h>

#include <nnt/nntest.h>
#include <nnt/nnt_Argument.h>

#define ADDITIONAL_SLEEP_FOR_AVOIDING_TIMEOUT

namespace nnt { namespace apm {

class ApmEnvironment : public ::testing::Environment
{
public:
    virtual void SetUp() override
    {
        nn::apm::Initialize();
    }

    virtual void TearDown() override
    {
    }
};

TEST(GetPerformanceModeTest, IsBoostMode)
{
#if (defined ADDITIONAL_SLEEP_FOR_AVOIDING_TIMEOUT)
    nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(1000LL));
#endif
    EXPECT_EQ(nn::apm::GetPerformanceMode(), nn::apm::PerformanceMode_Boost);
}

TEST(GetPerformanceModeTest, IsNormalMode)
{
#if (defined ADDITIONAL_SLEEP_FOR_AVOIDING_TIMEOUT)
    nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(1000LL));
#endif
    EXPECT_EQ(nn::apm::GetPerformanceMode(), nn::apm::PerformanceMode_Normal);
}

extern "C" void nninitStartup()
{
    ::testing::AddGlobalTestEnvironment(new nnt::apm::ApmEnvironment);
}

}} // namespace nnt::apm
