﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Log.h>

#include <nn/apm/apm.h>
#include <nn/apm/apm_System.h>
#include <nn/os.h>

namespace nnt { namespace apm {

extern "C" void nninitStartup()
{
}

extern "C" void nnMain()
{
    nn::apm::InitializeForSystem();
    nn::os::SystemEventType systemEvent;
    nn::apm::GetPerformanceEvent(&systemEvent, nn::apm::EventTarget_PerformanceModeChanged, nn::os::EventClearMode_ManualClear);
    nn::apm::Initialize();

    while ( true )
    {
        nn::os::WaitSystemEvent(&systemEvent);
        nn::os::ClearSystemEvent(&systemEvent);

        NN_LOG("PerformanceMode was changed.\n");

        nn::apm::PerformanceMode performanceMode = nn::apm::GetPerformanceMode();

        switch ( performanceMode )
        {
        case nn::apm::PerformanceMode_Normal:
            NN_LOG("PerformanceMode: Normal.\n");
            break;
        case nn::apm::PerformanceMode_Boost:
            NN_LOG("PerformanceMode: Boost.\n");
            break;
        default:
            NN_UNEXPECTED_DEFAULT;
        }
    }

    nn::apm::Finalize();
    nn::apm::FinalizeForSystem();
}

}}
