﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <utility>

#include <nn/nn_Common.h>

#include <nn/spl/spl_Types.h>

#include <nne/vcc/vcc_dram_ids.h>

#include <nnt/nntest.h>

#include "pcv_Conversion-hardware.nx.h"

namespace {

// nn::spl::DramId 型の列挙値が追加され次第リストを更新する
const std::pair<nn::spl::DramId, nne::vcc::DramId> DramIdPairs[] =
{
    { nn::spl::DramId_IcosaSamsung2g,  nne::vcc::DramId_Samsung4gb01 },
    { nn::spl::DramId_IcosaSamsung3g,  nne::vcc::DramId_Samsung6gb01 },
    { nn::spl::DramId_IcosaHynix,      nne::vcc::DramId_Hynix4gb01   },
    { nn::spl::DramId_IcosaMicron,     nne::vcc::DramId_Micron4gb01  },

    { nn::spl::DramId_CopperSamsung2g, static_cast<nne::vcc::DramId>(-1) },
    { nn::spl::DramId_CopperHynix,     static_cast<nne::vcc::DramId>(-1) },
    { nn::spl::DramId_CopperMicron,    static_cast<nne::vcc::DramId>(-1) },

    { nn::spl::DramId_IowaSamsung2g,   nne::vcc::DramId_Samsung4gb01 },
    { nn::spl::DramId_IowaX3Samsung2g, nne::vcc::DramId_Samsung4gb03 },
    { nn::spl::DramId_IowaX3Samsung4g, nne::vcc::DramId_Samsung8gb03 },
    { nn::spl::DramId_IowaX3Hynix,     static_cast<nne::vcc::DramId>(-1) },
    { nn::spl::DramId_IowaX3Micron,    static_cast<nne::vcc::DramId>(-1) },

    { nn::spl::DramId_HoagSamsung2g,   nne::vcc::DramId_Samsung4gb03 },
    { nn::spl::DramId_HoagSamsung4g,   nne::vcc::DramId_Samsung8gb03 },
    { nn::spl::DramId_HoagHynix,       static_cast<nne::vcc::DramId>(-1) },
    { nn::spl::DramId_HoagMicron,      static_cast<nne::vcc::DramId>(-1) },
};

class DramIdMapTest : public ::testing::TestWithParam<std::pair<nn::spl::DramId, nne::vcc::DramId>> { };

INSTANTIATE_TEST_CASE_P(DramIdPairs, DramIdMapTest, ::testing::ValuesIn(DramIdPairs));

} // namespace

// Windows 環境で動作する hardware=NX 向け DramId 変換テーブルの期待値テスト
// 内部実装更新時のエンバグ検出用テスト
TEST_P(DramIdMapTest, ConvertDramId)
{
    EXPECT_EQ(GetParam().second, nn::pcv::driver::detail::ConvertDramId(GetParam().first));
}
