﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/pcv/driver/detail/pcv_ModuleNames.h>

#include "ModuleNames.h"

namespace nnt {
namespace pcv {

const char * GetModuleName(nn::pcv::Module module) NN_NOEXCEPT
{
    int index = static_cast<int>(module);
    if (index >= static_cast<int>(nn::pcv::Module_NumModule))
    {
        return "Bad_Module";
    }
    for (auto& info : nn::pcv::driver::detail::ModuleNames)
    {
        if (info.module == module)
        {
            return info.name;
        }
    }
    return "Error: Module description name not added in pcv_ModuleNames.cpp\n";
}

} // pcvbasic
} // nnt
