﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>

#include <nn/pcv/driver/detail/pcv_ExpectedDefaultStates.h>

#include "ExpectedDefaultStates.h"

namespace nnt { namespace pcv {

bool GetClockEnabledDefault(nn::pcv::Module module) NN_NOEXCEPT
{
    int index = static_cast<int>(module);
    if (index >= static_cast<int>(nn::pcv::Module_NumModule))
    {
        NN_ABORT("Bad Module.\n");
    }
    for (auto& info : nn::pcv::driver::detail::ExpectedDefaultStates)
    {
        if (info.module == module)
        {
            return info.clockEnabled;
        }
    }

    NN_ABORT("Error: Expected default state not added in pcv_ExpectedDefaultStates.cpp.\n");
    return false;
}

}} // namespace nnt::pcv
