﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>
#include <nnt/result/testResult_Assert.h>
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/pctl/pctl_Api.h>
#include <nn/pctl/pctl_ApiSystem.h>
#include <nn/pctl/pctl_ApiForAuthentication.h>

TEST(PinCode, TestSetPinCode)
{
    nn::pctl::SetPinCode("0123");
    EXPECT_TRUE(nn::pctl::IsRestrictionEnabled());
}

TEST(PinCode, TestUnsetPinCode)
{
    nn::pctl::SetPinCode("0123");
    nn::pctl::SetPinCode(nullptr);
    EXPECT_FALSE(nn::pctl::IsRestrictionEnabled());
}

TEST(PinCode, TestPinCodeLength)
{
    nn::pctl::SetPinCode("01234");
    EXPECT_EQ(5, nn::pctl::GetPinCodeLength());
}

TEST(PinCode, TestPinCodeLength2)
{
    nn::pctl::SetPinCode("01234567");
    EXPECT_EQ(8, nn::pctl::GetPinCodeLength());
}

TEST(PinCode, TestGetPinCode1)
{
    nn::pctl::SetPinCode("01234");
    EXPECT_TRUE(nn::pctl::IsRestrictionEnabled());
    EXPECT_EQ(5, nn::pctl::GetPinCodeLength());

    char code[9];
    EXPECT_EQ(5, nn::pctl::GetPinCode(code, 9));
    EXPECT_EQ(0, std::strcmp(code, "01234"));

    EXPECT_EQ(3, nn::pctl::GetPinCode(code, 4));
}

TEST(PinCode, TestGetPinCode2)
{
    nn::pctl::SetPinCode("01234567");
    EXPECT_TRUE(nn::pctl::IsRestrictionEnabled());
    EXPECT_EQ(8, nn::pctl::GetPinCodeLength());

    char code[9];
    EXPECT_EQ(8, nn::pctl::GetPinCode(code, 9));
    EXPECT_EQ(0, std::strcmp(code, "01234567"));

    EXPECT_EQ(3, nn::pctl::GetPinCode(code, 4));
}

TEST(PinCode, TestUnlockRestrictionTemporarily_Success)
{
    nn::pctl::SetPinCode("0123");
    NNT_EXPECT_RESULT_SUCCESS(nn::pctl::UnlockRestrictionTemporarily("0123"));
    EXPECT_TRUE(nn::pctl::IsRestrictionTemporaryUnlocked());
    nn::pctl::RevertRestrictionTemporaryUnlocked();
}

TEST(PinCode, TestUnlockRestrictionTemporarily_Failure)
{
    nn::pctl::SetPinCode("0123");
    NNT_EXPECT_RESULT_FAILURE(nn::pctl::ResultWrongPinCode, nn::pctl::UnlockRestrictionTemporarily("3210"));
    EXPECT_FALSE(nn::pctl::IsRestrictionTemporaryUnlocked());
    nn::pctl::RevertRestrictionTemporaryUnlocked();
}

TEST(PinCode, TestUnlockSystemSettingsRestriction_Success)
{
    nn::pctl::SetPinCode("0123");
    NNT_EXPECT_RESULT_SUCCESS(nn::pctl::UnlockSystemSettingsRestriction("0123"));
    // temporary unlocked にはならない
    EXPECT_FALSE(nn::pctl::IsRestrictionTemporaryUnlocked());
    nn::pctl::RevertRestrictedSystemSettingsEntered();
}

TEST(PinCode, TestUnlockSystemSettingsRestriction_Success2)
{
    nn::pctl::SetPinCode("01234567");
    NNT_EXPECT_RESULT_SUCCESS(nn::pctl::UnlockSystemSettingsRestriction("01234567"));
    // temporary unlocked にはならない
    EXPECT_FALSE(nn::pctl::IsRestrictionTemporaryUnlocked());
    nn::pctl::RevertRestrictedSystemSettingsEntered();
}

TEST(PinCode, TestUnlockSystemSettingsRestriction_Failure)
{
    nn::pctl::SetPinCode("0123");
    NNT_EXPECT_RESULT_FAILURE(nn::pctl::ResultWrongPinCode, nn::pctl::UnlockSystemSettingsRestriction("3210"));
    EXPECT_FALSE(nn::pctl::IsRestrictionTemporaryUnlocked());
    nn::pctl::RevertRestrictedSystemSettingsEntered();
}

TEST(PinCode, TestUnlockSystemSettingsRestriction_Failure2)
{
    nn::pctl::SetPinCode("01234567");
    NNT_EXPECT_RESULT_FAILURE(nn::pctl::ResultWrongPinCode, nn::pctl::UnlockSystemSettingsRestriction("0123456"));
    EXPECT_FALSE(nn::pctl::IsRestrictionTemporaryUnlocked());
    nn::pctl::RevertRestrictedSystemSettingsEntered();
}

TEST(PinCode, TestUnlockSystemSettingsRestriction_Failure3)
{
    nn::pctl::SetPinCode("0123");
    NNT_EXPECT_RESULT_FAILURE(nn::pctl::ResultWrongPinCode, nn::pctl::UnlockSystemSettingsRestriction("01234"));
    EXPECT_FALSE(nn::pctl::IsRestrictionTemporaryUnlocked());
    nn::pctl::RevertRestrictedSystemSettingsEntered();
}

TEST(PinCode, TestFinalize)
{
    nn::pctl::SetPinCode(nullptr);
}
