﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>

#include "os_DemoUtil.h"

//  Siglo でタイマー機能が用意された時用にコードを残しておく

#if 0
/*!
  @brief        タイマーのデモです。

                自動・手動リセットタイマーを設定し、タイマーを待ちます。

  @return       なし。
*/
void TimerDemo1()
{
    NN_LOG("-- Timer Demo1 --\n");

    //----------------------------------------------------------------
    // 自動リセットタイマーの作成
    nn::os::Timer timer(false);

    DemoUtil::DumpObjectCounts();

    // ワンショットタイマーを１秒に設定
    timer.StartOneShot(nn::fnd::TimeSpan::FromSeconds(1));

    // タイマー待ち
    NN_LOG("Waiting Timer...\n");
    timer.Wait();
    NN_LOG("Timer Signaled.\n");

    // 周期タイマーを最初の１回を100ミリ秒、その後10ミリ秒毎に設定
    timer.StartPeriodic(nn::fnd::TimeSpan::FromMilliSeconds(100), nn::fnd::TimeSpan::FromMilliSeconds(10));

    for(int i = 0; i < 10; i++)
    {
        timer.Wait();
    }

    // タイマーを停止
    timer.Stop();

    // タイマーの破棄
    timer.Finalize();


    //----------------------------------------------------------------
    // 手動リセットタイマーの作成
    timer.Initialize(true);

    // ワンショットタイマーを１秒に設定
    timer.StartOneShot(nn::fnd::TimeSpan::FromSeconds(1));

    // タイマー待ち
    NN_LOG("Waiting Timer...\n");
    timer.Wait();
    NN_LOG("Timer Signaled.\n");

    // タイマー手動リセット
    timer.ClearSignal();

    // 周期タイマーを最初の１回を100ミリ秒、その後10ミリ秒毎に設定
    timer.StartPeriodic(nn::fnd::TimeSpan::FromMilliSeconds(100), nn::fnd::TimeSpan::FromMilliSeconds(10));

    for(int i = 0; i < 10; i++)
    {
        timer.Wait();
        timer.ClearSignal();
    }

    // タイマーを停止
    timer.Stop();

    // タイマーの破棄
    timer.Finalize();
}
#endif

/*!
  @brief        タイマーに関するデモです。

                タイマーのデモを実行します。

  @return       なし。
*/
void TimerDemo()
{
    NN_LOG("*** Timer Demo starts. ***\n");

#if 1
    NN_LOG("*** There is no Timer Demo. ***\n");
#else
    TimerDemo1();
#endif

    NN_LOG("*** End of Timer Demo ***\n");
}


