﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/nn_TimeSpan.h>
#include <nn/os.h>
#include "os_DemoUtil.h"

/*!
  @brief        チックのデモです。

                チック値を取得し、チック値の演算結果をミリ秒に変換します。

  @return       なし。
*/
void TickDemo1()
{
    NN_LOG("-- Tick Demo1 --\n");

    // チック値の取得
    nn::os::Tick    tick1 = nn::os::GetSystemTick();
    NN_LOG("Tick1 : %lld\n", tick1.GetInt64Value());

    // 1000ミリ秒スリープ
    NN_LOG("Sleep 1000 msec.\n");
    nn::os::SleepThread( nn::TimeSpan::FromMilliSeconds(1000) );

    // チック値の取得
    nn::os::Tick    tick2 = nn::os::GetSystemTick();
    NN_LOG("Tick2 : %lld\n", tick2.GetInt64Value());

    // チック値の演算結果をミリ秒に変換
    NN_LOG("Tick2 - Tick1 = %lld = %lld msec\n", (tick2 - tick1).GetInt64Value(), (tick2 - tick1).ToTimeSpan().GetMilliSeconds());
}

/*!
  @brief        チックに関するデモです。

                チックのデモを実行します。

  @return       なし。
*/
void TickDemo()
{
    NN_LOG("*** Tick Demo starts. ***\n");

    TickDemo1();

    NN_LOG("*** End of Tick Demo ***\n");
}

