﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../Common/test_Pragma.h"

#include <nn/os/os_Config.h>
#include <nn/nn_SdkText.h>
#include <nn/nn_Common.h>
#include <nn/os.h>
#include <nn/nn_Log.h>

#include <nnt/nntest.h>


namespace nnt { namespace os { namespace random {

TEST(Random, ApiCallTest)
{
    for (int i=0; i<10; ++i)
    {
        nn::Bit64 r;
        nn::os::GenerateRandomBytes(&r, sizeof(r));
        NN_LOG("%llX\n", r);
    }
}

//---------------------------------------------------------------------------

}}} // namespace nnt::os::random

