﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Config.h>
#include <nn/nn_Macro.h>

namespace nnt { namespace os { namespace multiWait {

//---------------------------------------------------------------------------

extern char InterruptNameTest1[32];
extern char InterruptNameTest2[32];
extern char InterruptNameTest3[32];
extern char InterruptNameTest4[32];

//---------------------------------------------------------------------------

class InterruptGeneratorForWin32
{
public:
    // コンストラクタ と デストラクタ
    InterruptGeneratorForWin32()    NN_NOEXCEPT;
    ~InterruptGeneratorForWin32()   NN_NOEXCEPT;

    HANDLE  GetEvent1() NN_NOEXCEPT
    {
        return m_Event1;
    }
    HANDLE  GetEvent2() NN_NOEXCEPT
    {
        return m_Event2;
    }
    HANDLE  GetEvent3() NN_NOEXCEPT
    {
        return m_Event3;
    }
    HANDLE  GetEvent4() NN_NOEXCEPT
    {
        return m_Event4;
    }

    void    TimerInterruptHandlerImpl() NN_NOEXCEPT;

private:
    HANDLE  m_Event1;            // 割込み通知用イベントのハンドル／AutoReset
    HANDLE  m_Event2;            // 割込み通知用イベントのハンドル／ManualReset
    HANDLE  m_Event3;            // 割込み通知用イベントのハンドル／NotSignaled
    HANDLE  m_Event4;            // 割込み通知用イベントのハンドル／Signaled
    HANDLE  m_TimerQueue;       // タイマーキューのハンドル
    HANDLE  m_TimerQueueTimer;  // タイマーキュータイマーのハンドル
};

typedef InterruptGeneratorForWin32  InterruptGenerator;

//---------------------------------------------------------------------------

inline void ClearTimerInterruptStatus()
NN_NOEXCEPT
{
    // 何もしない
}

//---------------------------------------------------------------------------

}}} // namespace nnt::os::multiWait

