﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <csetjmp>
#include <nn/os/os_Config.h>
#include <nn/nn_Common.h>

extern "C"
{

struct nntosJmpbufWithFpuContext
{
#if defined(NN_BUILD_CONFIG_OS_WIN32)
        jmp_buf     jmpbuf;
#elif defined(NN_BUILD_CONFIG_OS_HORIZON)
    #if defined NN_BUILD_CONFIG_CPU_ARM64
        uint64_t    jmpbuf[30];
    #elif defined NN_BUILD_CONFIG_CPU_ARM
        uint64_t    jmpbuf[14];
    #else
        #error "*** Invalid NN_BUILD_CONFIG_CPU_"
    #endif
#endif
};

int  nntosSetjmpWithFpuContext(nntosJmpbufWithFpuContext* jmp_buf);
void nntosLongjmpWithFpuContext(nntosJmpbufWithFpuContext* jmp_buf);

}   // extern "C"

