﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

//----------------------------------------------------------------------------
//  エスケープシーケンス
//----------------------------------------------------------------------------

#pragma once

//----------------------------------------------------------------------------

#define NN_ESC              "\x1b["

#define NN_ESC_CLEAR        NN_ESC "2"
#define NN_ESC_GO_UP        NN_ESC "1A"
#define NN_ESC_GO_DOWN      NN_ESC "1B"
#define NN_ESC_GO_RIGHT     NN_ESC "1C"
#define NN_ESC_GO_LEFT      NN_ESC "1D"

#define NN_ESC_NORMAL       NN_ESC "0m" NN_ESC "39m" NN_ESC "49m"
#define NN_ESC_BOLD         NN_ESC "1m"
#define NN_ESC_UNDERLINE    NN_ESC "4m"
#define NN_ESC_OPPOSITE     NN_ESC "7m"

#define NN_ESC_BLACK        NN_ESC "30m"
#define NN_ESC_RED          NN_ESC "31m"
#define NN_ESC_GREEN        NN_ESC "32m"
#define NN_ESC_YELLOW       NN_ESC "33m"
#define NN_ESC_BLUE         NN_ESC "34m"
#define NN_ESC_MAGENDA      NN_ESC "35m"
#define NN_ESC_CYAN         NN_ESC "36m"
#define NN_ESC_WHITE        NN_ESC "37m"

#define NN_ESC_BG_BLACK     NN_ESC "40m"
#define NN_ESC_BG_RED       NN_ESC "41m"
#define NN_ESC_BG_GREEN     NN_ESC "42m"
#define NN_ESC_BG_YELLOW    NN_ESC "43m"
#define NN_ESC_BG_BLUE      NN_ESC "44m"
#define NN_ESC_BG_MAGENDA   NN_ESC "45m"
#define NN_ESC_BG_CYAN      NN_ESC "46m"
#define NN_ESC_BG_WHITE     NN_ESC "47m"



