﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/omm/omm_Api.h>
#include <nn/os.h>

extern "C" void nnMain()
{
    nn::omm::Initialize();

    nn::os::SystemEvent hdcpStateChangeEvent;
    nn::omm::GetHdcpStateChangeEvent(&hdcpStateChangeEvent);

    // こちらは SA がいるときは上手く動かない (SA もこのイベントを得ているので)
    nn::os::SystemEvent hdcpAuthenticationFailedEvent;
    nn::omm::GetHdcpAuthenticationFailedEvent(&hdcpAuthenticationFailedEvent);

    for(;;)
    {
        int signal = nn::os::WaitAny(
                        hdcpStateChangeEvent.GetBase(),             // ClearMode_AutoClear
                        hdcpAuthenticationFailedEvent.GetBase()     // ClearMode_ManualClear
                        );
        if (signal == 0 && hdcpStateChangeEvent.TryWait())
        {
            NN_LOG("HdcpState changed. HdcpState=%d\n", nn::omm::GetHdcpState());
        }
        else if (signal == 1)
        {
            NN_LOG("HDCP Authentication Failed.\n");
            hdcpAuthenticationFailedEvent.Clear();
        }
    }
}
