﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#if defined(NN_BUILD_CONFIG_OS_WIN)
#include <nn/nn_Windows.h>
#endif

#include <cstdlib>

#include <nnt/nntest.h>
#include <nn/nn_Log.h>
#include <nn/nn_Result.h>
#include <nn/os/os_Debug.h>
#include <nn/os/os_Mutex.h>
#include <nn/time/time_ApiForMenu.h>
#include <nn/time/time_StandardNetworkSystemClock.h>
#include <nn/time/time_TimeZoneApi.h>

namespace nnt { namespace olsc {


#define NNT_OLSC_LOG(...) \
    do { NN_LOG(__VA_ARGS__); } while (NN_STATIC_CONDITION(false))

// bool を返す場合の結果の検査
#define NNT_OLSC_RETURN_FALSE_UNLESS(cond) \
    do { if (!(cond)) { NN_LOG("%s(%d): " #cond " => false\n", __FILE__, __LINE__); return false;} } while (NN_STATIC_CONDITION(false))

#define NNT_OLSC_RETURN_FALSE_UNLESS_NOT(cond) \
    NNT_OLSC_RETURN_FALSE_UNLESS(!(cond))

#define NNT_OLSC_RETURN_FALSE_UNLESS_EQ(lhs, rhs) \
    NNT_OLSC_RETURN_FALSE_UNLESS((lhs) == (rhs))

#define NNT_OLSC_RETURN_FALSE_UNLESS_NE(lhs, rhs) \
    NNT_OLSC_RETURN_FALSE_UNLESS((lhs) != (rhs))

// bool を返す場合の結果の検査
#define NNT_OLSC_RETURN_FALSE_UNLESS_RESULT_SUCCESS(result) \
    do { nn::Result _r = (result); if (!_r.IsSuccess()) { NN_LOG("%s(%d): Result(%d / %d)\n", __FILE__, __LINE__, _r.GetModule(), _r.GetDescription()); return false;} } while (NN_STATIC_CONDITION(false))

#define NNT_OLSC_RETURN_FALSE_UNLESS_RESULT_INCLUDED(exp, result) \
    do { nn::Result _r = (result); if (!exp::Includes(_r)) { NN_LOG("%s(%d): Result(%d / %d)\n", __FILE__, __LINE__, _r.GetModule(), _r.GetDescription()); return false;} } while (NN_STATIC_CONDITION(false))

// Result を返す場合の結果の検査
#define NNT_OLSC_RESULT_DO(result) \
    do { nn::Result _r = (result); if (!_r.IsSuccess()) { NN_LOG("%s(%d): Result(%d / %d)\n", __FILE__, __LINE__, _r.GetModule(), _r.GetDescription()); return _r;} } while (NN_STATIC_CONDITION(false))

// Result に対する ASSERT_TRUE 的なもの
#define NNT_OLSC_ASSERT_RESULT_SUCCESS(result) \
    do { nn::Result _r = (result); if (!_r.IsSuccess()) { NN_LOG("%s(%d): Result(%d / %d)\n", __FILE__, __LINE__, _r.GetModule(), _r.GetDescription()); ASSERT_TRUE(_r.IsSuccess());} } while (NN_STATIC_CONDITION(false))

#define NNT_OLSC_ASSERT_RESULT_INCLUDED(exp, result) \
    do { nn::Result _r = (result); if (!exp::Includes(_r)) { NN_LOG("%s(%d): Result(%d / %d)\n", __FILE__, __LINE__, _r.GetModule(), _r.GetDescription()); ASSERT_TRUE(exp::Includes(_r));} } while (NN_STATIC_CONDITION(false))

// Result に対する EXPECT_TRUE 的なもの
#define NNT_OLSC_EXPECT_RESULT_SUCCESS(result) \
    do { nn::Result _r = (result); if (!_r.IsSuccess()) { NN_LOG("%s(%d): Result(%d / %d)\n", __FILE__, __LINE__, _r.GetModule(), _r.GetDescription()); EXPECT_TRUE(_r.IsSuccess()); } } while (NN_STATIC_CONDITION(false))

#define NNT_OLSC_EXPECT_RESULT_INCLUDED(exp, result) \
    do { nn::Result _r = (result); if (!exp::Includes(_r)) { NN_LOG("%s(%d): Result(%d / %d)\n", __FILE__, __LINE__, _r.GetModule(), _r.GetDescription()); EXPECT_TRUE(exp::Includes(_r)); } } while (NN_STATIC_CONDITION(false))

}} // ~namespace nnt::account
