﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdlib>

#if defined(NN_BUILD_CONFIG_OS_WIN)
#include <nn/nn_Windows.h>
#endif

#include <nn/nn_Allocator.h>
#include <nn/nn_Common.h>

namespace nnt { namespace olsc {

class DefaultMemoryResource
    : public nn::MemoryResource
{
private:
    DefaultMemoryResource() NN_NOEXCEPT = default;

public:
    virtual void* do_allocate(std::size_t bytes, std::size_t alignment) NN_NOEXCEPT final NN_OVERRIDE
    {
#if defined(NN_BUILD_CONFIG_OS_WIN)
        return _aligned_malloc(bytes, alignment);
#elif defined(NN_BUILD_CONFIG_OS_HORIZON)
        return std::aligned_alloc(alignment, bytes);
#else
#error "Unsupported OS specified"
#endif
    }
    virtual void do_deallocate(void* p, std::size_t bytes, std::size_t alignment) NN_NOEXCEPT final NN_OVERRIDE
    {
#if defined(NN_BUILD_CONFIG_OS_WIN)
        NN_UNUSED(bytes);
        NN_UNUSED(alignment);
        return _aligned_free(p);
#elif defined(NN_BUILD_CONFIG_OS_HORIZON)
        NN_UNUSED(bytes);
        NN_UNUSED(alignment);
        std::free(p);
#else
#error "Unsupported OS specified"
#endif
    }
    virtual bool do_is_equal(const MemoryResource& other) const NN_NOEXCEPT final NN_OVERRIDE
    {
        return reinterpret_cast<uintptr_t>(static_cast<const MemoryResource*>(this)) == reinterpret_cast<uintptr_t>(&other);
    }

    static DefaultMemoryResource& GetInstance() NN_NOEXCEPT
    {
        NN_FUNCTION_LOCAL_STATIC(DefaultMemoryResource, s_Instance);
        return s_Instance;
    }
};

}} // ~namespace nnt::account
