﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/vi.h>
#include <nvn/nvn.h>

class AppBase
{
public:
    AppBase(int width, int height, const char* title);
    virtual ~AppBase();

    virtual void OnInit(PFNNVNBOOTSTRAPLOADERPROC loader, NVNnativeWindow nativeWindow) = 0;
    virtual void OnUpdate() = 0;
    virtual void OnRender() = 0;
    virtual void OnDestroy() = 0;

    bool IsExitRequested()
    {
        return m_RequireExit;
    }

    void RequestExit()
    {
        m_RequireExit = true;
    }

protected:
    bool m_RequireExit;
    int m_Width;
    int m_Height;
    const char* m_Title;
};

