﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>

#include <nn/nsd/nsd_Common.h>
#include <nn/nsd/detail/jwt/nsd_JwtParser.h>

using namespace nn::nsd::detail::jwt;
using namespace nn::nsd::detail::json;

TEST(GetJwtElements, Success)
{
    const char* testcase[] =
    {
        "a.b.c",
        "aaa.bb.c",
        "aaaa.bbbb.cccc"
    };
    for(auto& t : testcase)
    {
        JwtElements elements;
        NNT_ASSERT_RESULT_SUCCESS(GetJwtElements(&elements, t, strlen(t) + 1));
    }
}

TEST(GetJwtElements, InvalidElementSize)
{
    const char* testcase[] =
    {
        ".b.c",
        ".bb.cc",
        "..",
        ".b.",
        "..c",
        "a..c",
        "aa..cc",
        "a.b.",
        "aa.bb."
    };
    for(auto& t : testcase)
    {
        JwtElements elements;
        NNT_ASSERT_RESULT_FAILURE(nn::nsd::ResultJwtInvalidElementSize, GetJwtElements(&elements, t, strlen(t) + 1));
    }
}

TEST(GetJwtElements, InvalidDotCount)
{
    const char* testcase[] =
    {
        "a.b.c.",
        "aa.bb.cc.",
        "a.b",
        "aa.bb",
        "a",
        "aa"
    };
    for(auto& t : testcase)
    {
        JwtElements elements;
        NNT_ASSERT_RESULT_FAILURE(nn::nsd::ResultJwtInvalidDotCount, GetJwtElements(&elements, t, strlen(t) + 1));
    }
}
