﻿<#
    $ powershell -Version 2.0 -ExecutionPolicy Unrestricted MakeTestContents.ps1

    通常アプリ.nsp
    システムプログラム.nsp
    システムアップデートメタ.nsp ( Nup と同じメタID の必要がある？ )
    →システム2つでnfa, 通常アプリとnfa 併せて CUP.nsp
#>

# main 引数
param (
    # Qualify the platforms
    [string] $Platform = "NX-NXFP2-a64",

    # Qualify the intermediate working folder path
    [string] $IntermediateDirectory,

    # Qualify the system update meta identifier.
    [string] $UpdateId = "01001A500005E084",

    # Qualify the system program meta identifier.
    [string] $ProgramId = "01001A500005E085",

    # Qualify the application identifer with the cup archives.
    [string] $ApplicationId = "01001A500005E083",

    # Qualify the option for make test application.
    [string] $ApplicationOption = ""
)

# スクリプトパス関連 ( 全部文字列型らしい [string] )
$MyScriptPath           = $MyInvocation.MyCommand.Path
$MyScriptDirectoryPath  = [System.IO.Path]::GetDirectoryName($MyScriptPath)

Import-Module "${MyScriptDirectoryPath}\Modules\PlatformUtilities"

# SDK ROOTパス
$NintendoSdkRootPath = $(Find-NintendoSdkRootPath)

# NintendoSDK Integrate script module インポート
Import-Module "${NintendoSdkRootPath}\Integrate\Scripts\Modules\Error"
Import-Module "${NintendoSdkRootPath}\Integrate\Scripts\Modules\Path"
Import-Module "${MyScriptDirectoryPath}\Modules\FileUtilities"
Import-Module "${MyScriptDirectoryPath}\Modules\SdkToolUtilities"
Import-Module "${MyScriptDirectoryPath}\Modules\XmlFileUtilities"



# ================================
# main
# ================================
try {
    # CIジョブでのTestRunnerは、nact経由でステップ実行し、nactはUTF8で出力を受信している。
    # そのため、強制的にコンソールをUTF-8としている。
    # 但し通常のコード932のDOS窓上では本スクリプトから、Write-Hostなどに日本語指定が使えないので注意。
    $defUseEncoding = New-Object System.Text.UTF8Encoding($False)
    $defBackupConsoleEncoding = [System.Console]::OutputEncoding
    $defBackupEncode = $OutputEncoding
    [System.Console]::OutputEncoding = ${defUseEncoding}
    $OutputEncoding = ${defUseEncoding}

    # エンコード情報表示
    [string] $defConsoleEncode = [System.Console]::OutputEncoding.EncodingName
    [string] $defStartupEncode = $defBackupEncode.EncodingName
    [string] $defCurrentEncode = $OutputEncoding.EncodingName
    Write-Host "[Console]::OutputEncoding : ${defConsoleEncode}"
    Write-Host "Startup `$OutputEncoding   : ${defStartupEncode}"
    Write-Host "Current `$OutputEncoding   : ${defCurrentEncode}"

    # 中間ファイル作成作業フォルダ存在確認
    [string] $IntermediateDirectory = $(Get-AbsoluteFullPath ${IntermediateDirectory})
    $(Edit-MakeDirectory ${IntermediateDirectory})

    Write-Host "Platform        : ${Platform}"
    Write-Host "SDK Root        : ${NintendoSdkRootPath}"
    Write-Host "ScriptPath      : ${MyScriptPath}"
    Write-Host "ScriptDirectory : ${MyScriptDirectoryPath}"

    # 64/32 アーキテクトシグネチャ取得
    [string] $ArchSignature = $(Get-ArchitectSignature ${Platform})
    Write-Host "Architexture    : ${ArchSignature}"

    [int] $defBaseVersion = 1
    [int] $defNextVersion = ${defBaseVersion} + 1
    [int] $defNext2Version = ${defNextVersion} + 1

    # ベースファイル名生成, メタファイル生成
    [string] $defSystemProgramBaseNameV0 = $(Out-MakeSystemProgramMeta ${IntermediateDirectory} ${ProgramId} ${defBaseVersion} ${ArchSignature})
    [string] $defSystemProgramBaseNameV1 = $(Out-MakeSystemProgramMeta ${IntermediateDirectory} ${ProgramId} ${defNextVersion} ${ArchSignature})
    [string] $defSystemProgramBaseNameV2 = $(Out-MakeSystemProgramMeta ${IntermediateDirectory} ${ProgramId} ${defNext2Version} ${ArchSignature})
    [string] $defSystemUpdateBaseNameV0 =  "${UpdateId}_v${defBaseVersion}"
    [string] $defSystemUpdateBaseNameV1 =  "${UpdateId}_v${defNextVersion}"
    [string] $defSystemUpdateBaseNameV2 =  "${UpdateId}_v${defNext2Version}"

    # system program meta ファイルパス
    [string] $defSystemProgramMetaV0 = "${IntermediateDirectory}\${defSystemProgramBaseNameV0}.nmeta"
    [string] $defSystemProgramMetaV1 = "${IntermediateDirectory}\${defSystemProgramBaseNameV1}.nmeta"
    [string] $defSystemProgramMetaV2 = "${IntermediateDirectory}\${defSystemProgramBaseNameV2}.nmeta"

    # system program nsp ファイルパス
    [string] $defSystemProgramNspV0 = "${IntermediateDirectory}\${defSystemProgramBaseNameV0}.nsp"
    [string] $defSystemProgramNspV1 = "${IntermediateDirectory}\${defSystemProgramBaseNameV1}.nsp"
    [string] $defSystemProgramNspV2 = "${IntermediateDirectory}\${defSystemProgramBaseNameV2}.nsp"

    # system update nsp ファイルパス
    [string] $defSystemUpdateNspV0 = "${IntermediateDirectory}\${defSystemUpdateBaseNameV0}.nsp"
    [string] $defSystemUpdateNspV1 = "${IntermediateDirectory}\${defSystemUpdateBaseNameV1}.nsp"
    [string] $defSystemUpdateNspV2 = "${IntermediateDirectory}\${defSystemUpdateBaseNameV2}.nsp"

    # 入力メタファイルの存在確認
    $(Test-ExistFile ${defSystemProgramMetaV0})
    $(Test-ExistFile ${defSystemProgramMetaV1})
    $(Test-ExistFile ${defSystemProgramMetaV2})

    # MakeTestApplication
    [string] $defMakeTestApplication = "${NintendoSdkRootPath}\Tools\CommandLineTools\MakeTestApplication\MakeTestApplication.exe"
    [string] $defWorkDirectory = "${IntermediateDirectory}\_NspWorkTemporary_"

    # application nsp v0 生成
    [string] $defApplicationBaseName = "${ApplicationId}_v0.${ArchSignature}"
    [string] $defApplicationNsp = "${IntermediateDirectory}\${defApplicationBaseName}.nsp"
    $(Edit-MakeDirectory ${defWorkDirectory})
    Invoke-Expression "& `"${defMakeTestApplication}`" --type Application --id 0x${ApplicationId} --ver 0 --output-file-name ${defApplicationBaseName} -o `"${IntermediateDirectory}`" --work-directory `"${defWorkDirectory}`" ${ApplicationOption}"
    $(Test-ExistFile ${defApplicationNsp})

    # system program nsp 生成 ( v0/v1/v2 )
    $(Edit-MakeDirectory ${defWorkDirectory})
    Invoke-Expression "& `"${defMakeTestApplication}`" --type SystemProgram --meta `"${defSystemProgramMetaV0}`" -o `"${IntermediateDirectory}`" --output-file-name ${defSystemProgramBaseNameV0} --work-directory `"${defWorkDirectory}`""
    $(Test-ExistFile ${defSystemProgramNspV0})
    $(Edit-MakeDirectory ${defWorkDirectory})
    Invoke-Expression "& `"${defMakeTestApplication}`" --type SystemProgram --meta `"${defSystemProgramMetaV1}`" -o `"${IntermediateDirectory}`" --output-file-name ${defSystemProgramBaseNameV1} --work-directory `"${defWorkDirectory}`""
    $(Test-ExistFile ${defSystemProgramNspV1})
    $(Edit-MakeDirectory ${defWorkDirectory})
    Invoke-Expression "& `"${defMakeTestApplication}`" --type SystemProgram --meta `"${defSystemProgramMetaV2}`" -o `"${IntermediateDirectory}`" --output-file-name ${defSystemProgramBaseNameV2} --work-directory `"${defWorkDirectory}`""
    $(Test-ExistFile ${defSystemProgramNspV2})

    # System nfa ( v0/v1/v2 )
    [string[]] $defArrayNspFilesV0 = [string[]]( ${defSystemProgramNspV0} )
    [string] $defContentsNfaV0 = $(Out-MakeContentsNfa ${IntermediateDirectory} ${defSystemUpdateBaseNameV0} ${defArrayNspFilesV0})
    [string[]] $defArrayNspFilesV1 = [string[]]( ${defSystemProgramNspV1} )
    [string] $defContentsNfaV1 = $(Out-MakeContentsNfa ${IntermediateDirectory} ${defSystemUpdateBaseNameV1} ${defArrayNspFilesV1})
    [string[]] $defArrayNspFilesV2 = [string[]]( ${defSystemProgramNspV2} )
    [string] $defContentsNfaV2 = $(Out-MakeContentsNfa ${IntermediateDirectory} ${defSystemUpdateBaseNameV2} ${defArrayNspFilesV2})

    # system update nsp 生成 ( v0/v1/v2 )
    [string] $defMakeCupArchive = "${NintendoSdkRootPath}\Tools\CommandLineTools\MakeCupArchive.exe"
    [string] $defKeyConfig = "${NintendoSdkRootPath}\Tools\CommandLineTools\AuthoringTool\AuthoringTool.ocean.keyconfig.xml"
    Invoke-Expression "& `"${defMakeCupArchive}`" --system-meta-id 0x${UpdateId} --system-meta-version ${defBaseVersion} -o `"${defSystemUpdateNspV0}`" -i `"${defContentsNfaV0}`" --keyconfig `"${defKeyConfig}`""
    $(Test-ExistFile ${defSystemUpdateNspV0})
    Invoke-Expression "& `"${defMakeCupArchive}`" --system-meta-id 0x${UpdateId} --system-meta-version ${defNextVersion} -o `"${defSystemUpdateNspV1}`" -i `"${defContentsNfaV1}`" --keyconfig `"${defKeyConfig}`""
    $(Test-ExistFile ${defSystemUpdateNspV1})
    Invoke-Expression "& `"${defMakeCupArchive}`" --system-meta-id 0x${UpdateId} --system-meta-version ${defNext2Version} -o `"${defSystemUpdateNspV2}`" -i `"${defContentsNfaV2}`" --keyconfig `"${defKeyConfig}`""
    $(Test-ExistFile ${defSystemUpdateNspV2})

    Write-Host "`n >>>>>>> Complete nsp creating. <<<<<<< `n"

    # Version 0 CupConfig 出力
    $(Out-MakeCupConfigFile ${IntermediateDirectory} ${defApplicationNsp} ${defSystemUpdateNspV0} ${defBaseVersion} )

    # Version 1 CupConfig 出力
    $(Out-MakeCupConfigFile ${IntermediateDirectory} ${defApplicationNsp} ${defSystemUpdateNspV1} ${defNextVersion} )

    # Version 2 CupConfig 出力
    $(Out-MakeCupConfigFile ${IntermediateDirectory} ${defApplicationNsp} ${defSystemUpdateNspV2} ${defNext2Version} )

} catch [Exception] {

    Write-ErrorRecord $_
    $LastExitCode = 1

} finally {

    $OutputEncoding = $defBackupEncode
    [System.Console]::OutputEncoding = $defBackupConsoleEncoding

}
exit $LastExitCode

