﻿<#
    .SYNOPSIS
        Private option utilities module

    .DESCRIPTION
        This file defines functions for private operations
#>

# 基本パス関連 ( 全部文字列型らしい [string] )
$MyScriptPath          = $MyInvocation.MyCommand.Path
$MyScriptDirectoryPath = [System.IO.Path]::GetDirectoryName($MyScriptPath)

# プロキシオプション文字列生成 ( --proxy "" )
# 環境変数 "NN_TEST_SCRIPT_PROXY_CONFIGURATION" が設定されていた場合、そちらが優先されます。
# 環境変数 "NN_TEST_SCRIPT_PROXY_CONFIGURATION" が "" 形式の空文字指定の場合、プロキシ設定は指定なしとして扱われます。
function New-ProxyOption( [string]$defExpectProxy )
{
    [string] $defResultProxy = ""
    if ( $(Test-Path env:${NN_TEST_SCRIPT_PROXY_CONFIGURATION}) -and ( ${env:NN_TEST_SCRIPT_PROXY_CONFIGURATION}.Length -gt 0 ) )
    {
        # "xxx" 形式文字列からダブルコーテーション外す
        [string] $defEnvProxy = ""
        $matchResult = [regex]::Match( ${env:NN_TEST_SCRIPT_PROXY_CONFIGURATION}, "^`".*?`"$" )
        if ( $matchResult.Success )
        {
            $matchedValue = $matchResult.Value
            [string] $defEnvProxy = [regex]::Replace( ${matchedValue}, "^`"", "" )
            [string] $defEnvProxy = [regex]::Replace( ${defEnvProxy}, "`"$", "" )
        }
        if ( ${defEnvProxy}.Length -gt 0 )
        {
            $defResultProxy = "--proxy `"${defEnvProxy}`""
        }
    }
    elseif ( ${defExpectProxy}.Length -gt 0 )
    {
        $defResultProxy = "--proxy `"${defExpectProxy}`""
    }
    return $defResultProxy
}

Export-ModuleMember -Function *
