﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nnt/nntest.h>
#include <nnt/nnt_Argument.h>
#include <nnt/result/testResult_Assert.h>
#include <nnt/nsutil/nsutil_InstallUtils.h>
#include <nnt/npnsUtil.h>

#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/os.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/util/util_FormatString.h>

#include <nn/ns/ns_Result.h>

#include <nn/lr/lr_Service.h>
#include <nn/lr/lr_AddOnContentLocationResolver.h>

using namespace nn;

namespace {

    class RegisterAddOnContentStorageTest : public testing::Test
    {
    public:
    protected:

        static void SetUpTestCase()
        {
            ncm::Initialize();
            lr::Initialize();
        }

        static void TearDownTestCase()
        {
            nn::ncm::Finalize();
            nn::lr::Finalize();
        }

    };

} // namespace

struct TestSpec
{
    ncm::DataId dataId;
    ncm::StorageId masterStorage;
};

TestSpec specs[] = {
    { { 0x0100cb5000003001 }, ncm::StorageId::BuildInUser },
    { { 0x0100cb5000003002 }, ncm::StorageId::BuildInUser },
    { { 0x0100cb5000003003 }, ncm::StorageId::BuildInUser },
};

TEST_F(RegisterAddOnContentStorageTest, Basic)
{
    lr::AddOnContentLocationResolver ar;
    NNT_EXPECT_RESULT_SUCCESS(nn::lr::OpenAddOnContentLocationResolver(&ar));

    for (auto spec : specs)
    {
        lr::Path path;
        NNT_ASSERT_RESULT_SUCCESS(ar.ResolveAddOnContentPath(&path, spec.dataId));

        ncm::ContentMetaDatabase db;
        NNT_ASSERT_RESULT_SUCCESS(ncm::OpenContentMetaDatabase(&db, spec.masterStorage));

        ncm::ContentId contentId;
        NNT_ASSERT_RESULT_SUCCESS(db.GetLatestData(&contentId, spec.dataId));

        ncm::ContentStorage cs;
        NNT_ASSERT_RESULT_SUCCESS(ncm::OpenContentStorage(&cs, spec.masterStorage));

        ncm::Path masterPath;
        cs.GetPath(&masterPath, contentId);

        EXPECT_STREQ(masterPath.string, path.string);
    }
}
