﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        半起床の全テストを実施後に、開発機をテスト実施前相当の状態に戻す操作を行います。

    .PARAMETER Target
        ControlTarget, RunOnTarget の -t オプションに渡す文字列

    .PARAMETER TrialCount
        ネットワーク接続を伴う DevMenuCommand 処理の試行回数。
        2 以上を指定すると、その回数を上限として実行に成功するまで再試行を行います。1 ならば
        再試行を行いません。一時的なネットワーク接続の問題を回避するために使用します。
#>

param
(
    [Parameter(Mandatory = $true)]
    [string]
    $Target,

    [int]
    $TrialCount
)

$ErrorActionPreference = 'Stop'

Set-StrictMode -Version Latest

$ScriptPath      = $MyInvocation.MyCommand.Path
$ScriptDirectory = Split-Path $ScriptPath


# --------------------------------------------------------------------------
# 共通モジュール読み込み & 定数定義
# --------------------------------------------------------------------------
Import-Module "$ScriptDirectory\Common"
. "$ScriptDirectory\Constants.ps1"
. "$ScriptDirectory\Functions.ps1"

$EmptyNetworkSettingsPath = Resolve-Path "$ScriptDirectory\NetworkSettings.empty.json"


# --------------------------------------------------------------------------
# 開発機の状態が分からないのでリセットをかける
# --------------------------------------------------------------------------
Invoke-TargetReset $Target


# --------------------------------------------------------------------------
# テストで行った変更を元に戻す
# --------------------------------------------------------------------------
Teardown-DemoDownload $Target $TestApplicationId -TrialCount $TrialCount
Teardown-SystemUpdate $Target -TrialCount $TrialCount

Invoke-ContentsUploader register-version,--content-meta-id,$TestApplicationPatchId,--application-id,$TestApplicationId,--type,Patch,--content-meta-version,$TestApplicationV1Version,-e,td1


# --------------------------------------------------------------------------
# テスト準備で行った設定を元に戻す
# --------------------------------------------------------------------------
Invoke-DevMenuCommandSystem $Target debug,set-boolean-fwdbg,--name,ns.notification,--key,enable_request_on_cold_boot,true
Invoke-DevMenuCommandSystem $Target debug,set-integer-fwdbg,--name,ns.notification,--key,debug_waiting_limit,0
Invoke-DevMenuCommandSystem $Target bgtc,config-battery-saver,enable
Invoke-DevMenuCommandSystem $Target npns,set-sleep-periodic-interval,10800

Invoke-DevMenuCommandSystem $Target shop,delete-all-rights,0 -TrialCount $TrialCount
Invoke-DevMenuCommandSystem $Target account,clear_all -TrialCount $TrialCount
Invoke-DevMenuCommandSystem $Target shop,unlink-device-all -TrialCount $TrialCount
Invoke-DevMenuCommandSystem $Target shop,unregister-device-account -TrialCount $TrialCount

Invoke-DevMenuCommandSystem $Target servicediscovery,delete-all -TrialCount $TrialCount
Invoke-SettingsManager $Target Import,$EmptyNetworkSettingsPath
Invoke-TargetReset $Target
