﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Abort.h>
#include <nn/nn_Result.h>

#include <nn/oe.h>
#include <nn/os.h>
#include <nn/fs/fs_Host.h>

#include <nnt/nntest.h>

#include <nn/es/es_InitializationApi.h>
#include <nn/ncm/ncm_Service.h>
#include <nn/ncm/ncm_Result.h>
#include <nn/ns/ns_Result.h>
#include <nn/ns/ns_ApplicationManagerApi.h>
#include <nn/ns/ns_DevelopApi.h>
#include <nn/ns/ns_InitializationApi.h>
#include <nn/ns/ns_ApiForDfc.h>

#include "ApplicationManagerTestTool_FsUtilities.h"
#include "ApplicationManagerTestTool_HtcUtil.h"
#include "ApplicationManagerTestTool_Option.h"
#include "ApplicationManagerTestTool_AppOperation.h"
#include "ApplicationManagerTestTool_CheckProcess.h"

const char HelpMessage[] =
    "  usage: ApplicationManagerTestTool <inputTestFile_AbsolutePath>\n"
    "\n"
    "  Need to add <inputTestFile_AbsolutePath>\n"
    "";

void Initialize() NN_NOEXCEPT
{
    nn::fs::MountHostRoot();

#ifdef NN_BUILD_CONFIG_OS_WIN
    nn::ns::InitializeDependenciesForDfc();
#else
    nn::oe::Initialize();
    nn::ncm::Initialize();
    nn::es::Initialize();
#endif

    //nn::ns::InitializeForDevelop();
    nn::ns::Initialize();

    HtcUtil::Initialize();

    AppOperation::Initialize();

    InitializeCheckProcess();
}

void Finalize() NN_NOEXCEPT
{
    HtcUtil::Finalize();

    nn::ns::Finalize();
    //nn::ns::FinalizeForDevelop()

#ifdef NN_BUILD_CONFIG_OS_WIN
    nn::ns::FinalizeDependenciesForDfc();
#else
    nn::ncm::Finalize();
    nn::es::Finalize();
#endif
}


int Process(int argc, char** argv) NN_NOEXCEPT
{
    ::testing::InitGoogleTest(&argc, argv);

    if (argc < 2)
    {
        NN_LOG(HelpMessage);
        return -1;
    }

    Option::SetArgument(argc, argv);

    bool isSkipPathCheck = false;
    if (Option::HasKey("--cleanupsd") || Option::HasKey("--formatsd"))
    {
        // 特殊オプションが指定されていた場合、厳密なファイルパスのチェックなどは実施しない
        isSkipPathCheck = true;
    }

    if (isSkipPathCheck == false)
    {
        const char* inputPath = argv[1];
        if (fsutil::IsAbsolutePath(inputPath) == false)
        {
            NN_LOG(" [Error] File is Not AbsolutePath : %s\n", inputPath);
            return -1;
        }

        if (fsutil::IsExistPath(inputPath) == false)
        {
            NN_LOG(" [Error] File Not Found : %s\n", inputPath);
            return -1;
        }
    }

    int result = RUN_ALL_TESTS();

    NN_UNUSED(result);

    return 0;
}

extern "C" void nnMain()
{
    Initialize();

    Process(nn::os::GetHostArgc(), nn::os::GetHostArgv());

    Finalize();
}
