﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <sstream>
#include <nn/nn_Common.h>

static const char* CONTENT_TYPE_APPLICATION = "Application";
static const char* CONTENT_TYPE_ADD_ON_CONTENT = "AddOnContent";
static const char* CONTENT_TYPE_PATCH = "Patch";

static const char* INSTALL_STORAGE_BUILTIN = "builtin";
static const char* INSTALL_STORAGE_SDCARD = "sdcard";
static const char* INSTALL_STORAGE_AUTO = "auto";

class StringUtil
{
public:
    static const char* ToString(bool inBool) NN_NOEXCEPT
    {
        return (inBool == true) ? "True" : "False";
    }

    template <typename T>
    static std::string ToString(T inVal) NN_NOEXCEPT
    {
        std::ostringstream os;
        os << inVal;
        return os.str();
    }

    static double ToDouble(const std::string& inStr) NN_NOEXCEPT
    {
        std::istringstream is(inStr);
        double num = 0.0;
        is >> num;
        return num;
    }

    static nn::Bit32 ToBit32(const std::string& inStr) NN_NOEXCEPT
    {
        std::istringstream is(inStr);
        nn::Bit32 num = 0x00000000;
        is >> num;
        return num;
    }

    // 文字列型から任意の数値型へ
    template <typename T>
    static T ToNum(const std::string& inNumStr) NN_NOEXCEPT
    {
        std::istringstream is(inNumStr);
        T num = 0;

        if (inNumStr.find("0x") != std::string::npos)
        {
            is >> std::hex >> num;
        }
        else
        {
            is >> num;
        }

        return num;
    }
};
