﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/fs.h>
#include <nn/nifm.h>
#include <nn/socket.h>
#include <nn/nn_Assert.h>
#include <nn/nn_BitTypes.h>
#include <nn/es/es_Types.h>
#include <nn/es/es_InitializationApi.h>
#include <nn/ncm/ncm_Service.h>
#include <nn/spl/spl_Api.h>
#include <nnt/nntest.h>
#include <curl/curl.h>
#include <nn/nim/srv/nim_EciAccessor.h>

namespace {
    class EciAccessorTest : public testing::Test
    {
    protected:
        nn::nim::srv::HttpConnection httpConnection;
        nn::nim::srv::EciAccessor EciAccessor;
        nn::nim::srv::DeviceContext deviceContext;

        nn::nim::DeviceAccountId deviceAccountId;
        nn::nim::DeviceAccountToken deviceAccountToken;

        EciAccessorTest()
        {
            NN_ABORT_UNLESS_RESULT_SUCCESS(deviceContext.Initialize());
            NN_ABORT_UNLESS_RESULT_SUCCESS(httpConnection.Initialize(&deviceContext));
            NN_ABORT_UNLESS_RESULT_SUCCESS(EciAccessor.Initialize(&deviceContext, &httpConnection));

            deviceAccountId = { "" };
            deviceAccountToken = { "" };
        }

        virtual void SetUp()
        {
        }

        virtual void TearDown()
        {
        }

        static void SetUpTestCase()
        {
            NN_ABORT_UNLESS_RESULT_SUCCESS(nn::nifm::Initialize());
            nn::nifm::SubmitNetworkRequestAndWait();

            static NN_ALIGNAS(4096) uint8_t s_SocketMemoryPoolBuffer[nn::socket::DefaultSocketMemoryPoolSize];
            NN_ABORT_UNLESS_RESULT_SUCCESS(nn::socket::Initialize(reinterpret_cast<void*>(s_SocketMemoryPoolBuffer),
                nn::socket::DefaultSocketMemoryPoolSize,
                nn::socket::DefaultSocketAllocatorSize,
                nn::socket::DefaultConcurrencyLimit));
            auto result = curl_global_init(CURL_GLOBAL_ALL);
            NN_ASSERT_EQUAL(CURLE_OK, result);

            nn::es::Initialize();

#ifdef NN_BUILD_CONFIG_OS_HORIZON
            nn::spl::Initialize();
#endif
        }

        static void TearDownTestCase()
        {
            curl_global_cleanup();
            nn::socket::Finalize();

            nn::nifm::CancelNetworkRequest();

            nn::es::Finalize();

#ifdef NN_BUILD_CONFIG_OS_HORIZON
            nn::spl::Finalize();
#endif
        }
    };
}

TEST_F(EciAccessorTest, GetAccountStatus)
{
    nn::ec::system::DeviceAccountStatus status;
    EciAccessor.GetAccountStatus(&status, deviceAccountToken);
}

TEST_F(EciAccessorTest, Register)
{
    nn::nim::DeviceAccountId id;
    nn::nim::DeviceAccountToken token;
    EciAccessor.Register(&id, &token);
}

TEST_F(EciAccessorTest, Unregister)
{
    EciAccessor.Unregister();
}

TEST_F(EciAccessorTest, AccountGetETicketsByRightsId)
{
    int outTicketIdCount;
    nn::Bit64 ticketIdList[10];
    char buffer[4096];

    nn::es::RightsIdIncludingKeyId rightsId = { {0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00} };

    EciAccessor.AccountListETicketIdsByRightsId(&outTicketIdCount, ticketIdList, sizeof(ticketIdList) / sizeof(ticketIdList[0]), deviceAccountId, deviceAccountToken, rightsId);
    bool tmpIsPrepurchaseRecordDownloaded;
    int tmpComeBackAfter;
    EciAccessor.AccountGetETickets(&tmpIsPrepurchaseRecordDownloaded, &tmpComeBackAfter, buffer, sizeof(buffer), deviceAccountId, deviceAccountToken, ticketIdList, outTicketIdCount);
}

TEST_F(EciAccessorTest, AccountGetETickets)
{
    int outTicketIdCount;
    nn::Bit64 ticketIdList[10];
    char buffer[4096];

    EciAccessor.AccountListETicketIds(buffer, sizeof(buffer), &outTicketIdCount, ticketIdList, sizeof(ticketIdList) / sizeof(ticketIdList[0]), deviceAccountId, deviceAccountToken);
    bool tmpIsPrepurchaseRecordDownloaded;
    int tmpComeBackAfter;
    EciAccessor.AccountGetETickets(&tmpIsPrepurchaseRecordDownloaded, &tmpComeBackAfter, buffer, sizeof(buffer), deviceAccountId, deviceAccountToken, ticketIdList, outTicketIdCount);
}

TEST_F(EciAccessorTest, GetRegistrationInfo)
{
    nn::ec::system::DeviceAccountStatus status;
    nn::nim::DeviceAccountId id;
    nn::nim::DeviceAccountToken token;
    EciAccessor.GetRegistrationInfo(&status, &id, &token);
}

