﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Import network setting

    .DESCRIPTION
        Import network setting
#>

function Resolve-PathSafe
{
    param
    (
        [string] $Path
    )
     
    $ExecutionContext.SessionState.Path.GetUnresolvedProviderPathFromPSPath($Path)
}

function FindFullPath($path, $target)
{
    If(Test-Path $path)
    {
        $ret = (Get-ChildItem -path $path -r -include $target | Sort-Object LastWriteTime -Descending)
        If($null -eq $ret)
        {
            return $null
        }
        Elseif($ret -is [system.array])
        {
            $ret = $ret[0]
        }

        If(Test-Path $ret)
        {
            $ret = Resolve-Path $ret
            return $ret
        }
    }
    return $null
}

$DevMenuCommandSystem = FindFullPath "..\..\Programs\Eris\Outputs\" "DevMenuCommandSystem.nsp"

if($null -eq $DevMenuCommandSystem)
{
    Write-Host "DevMenuCommandSystem not found." -ForegroundColor Red
    return
}
else
{
    Write-Host $DevMenuCommandSystem
}

$RunOnTarget = "..\..\Tools\CommandLineTools\RunOnTarget.exe"
$RunOnTarget = If(Test-Path $RunOnTarget) { Resolve-Path $RunOnTarget } Else { $null }

$PassCodeHash = @{td1="F9h2izRI"; dd1="aDcTGkJs"}

$Options = @()
$PassCodes = @()
Foreach($key in $PassCodeHash.Keys)
{
    $OptionName = "&" + $key
    $PassCodes += $PassCodeHash[$key]
    $Options += new-object System.Management.Automation.Host.ChoiceDescription $OptionName, $PassCodeHash[$key]
}

$Env = $host.ui.PromptForChoice("<Environment>", "Select environment", [System.Management.Automation.Host.ChoiceDescription[]]($Options), 1)

$PInfo = New-Object System.DIagnostics.ProcessStartInfo
$PInfo.RedirectStandardError = $true
$PInfo.RedirectStandardOutput = $true
$PInfo.UseShellExecute = $false

$P = New-Object System.Diagnostics.Process

# servicediscovery
$PInfo.FileName = $RunOnTarget
$PInfo.Arguments = "$DevMenuCommandSystem -- servicediscovery import-all " + $PassCodes[$Env]

Write-Host $PInfo.FileName
Write-Host $PInfo.Arguments

$P.StartInfo = $PInfo
$P.Start() | Out-Null
$P.WaitForExit(15000)

$Stdout = $P.StandardOutput.ReadToEnd()
$Stderr = $P.StandardError.ReadToEnd()

Write-Host $Stdout $Stderr
