#!/bin/bash

API_LIST=" \
    BreakTag \
    CreateApplicationArea \
    DeleteApplicationArea \
    DeleteRegisterInfo \
    Flush \
    FlushDebug \
    Format \
    GetAdminInfo \
    GetApplicationArea \
    GetCommonInfo \
    GetRegisterInfo \
    GetTagInfo \
    Mount \
    OpenApplicationArea \
    Restore \
    SetApplicationArea \
    SetRegisterInfo \
    StartDetection \
    StopDetection \
    Unmount \
"

NOT_CHECK_API_LIST=" \
    InitializeSystem \
    FinalizeSystem \
    InitializeDebug \
    FinalizeDebug \
    ListDevices \
    GetState \
    GetDeviceState \
    State \
    AttachActivateEvent \
    AttachDeactivateEvent \
"

RESULT_LIST=" \
    ResultSuccess \
    ResultNeedRetry \
    ResultIsBusy \
    ResultTimeOutError \
    ResultConnectionError \
    ResultNotFound \
    ResultTagNotFound \
    ResultCharacterNotFound \
    ResultFailed \
    ResultOperationFailed \
    ResultFatalError \
    ResultUnexpected \
    ResultInvalidDeviceState \
    ResultNotSupported \
    ResultNeedRestore \
    ResultNeedFormat \
    ResultNeedCreate \
    ResultNeedRegister \
    ResultAlreadyCreated \
    ResultAccessIdMisMatch \
    ResultNotBroken \
    ResultInvalidFormatVersion \
    ResultNotImplemented \
    ResultSleep \
    ResultNfcDisabled \
    ResultNotForeground \
    ResultNotUpdated \
    ResultNfcDeviceNotFound \
    ResultMaxNfcDeviceActivated \
    ResultConflictFunction \
    ResultBadRequest \
    ResultInvalidNickname \
    ResultInvalidMii \
    ResultEntryNotFound \
    ResultBackupError \
    ResultNoBackupFile \
    ResultBackupOpenFailed \
    ResultBackupReadFailed \
    ResultBackupWriteFailed \
    ResultBackupCrcBroken \
    ResultDataAccessFailed \
    ResultNfcDeviceError \
    ResultNfcInitError \
    ResultNfcTermError \
    ResultNfcOpenError \
    ResultNfcCloseError \
    ResultInvalidFormat \
    ResultInvalidTag \
    ResultAuthenticationError \
    ResultInvalidRomArea \
    ResultUidMisMatch \
    Unknown \
"

NOT_PARSE=not_perse.txt
TMP_FILE=tmp.txt
grep NFP_API_CALL $1 > $TMP_FILE
sed -i -e "s/.*\[NFP_API_CALL\]\(.*\),call count.*/\1/g" $TMP_FILE

rm -f $NOT_PARSE
for api in $API_LIST
do
    TMP_API_FILE=tmp_${api}.txt
    grep ${api}\(\) $TMP_FILE > $TMP_API_FILE
    for ret in $RESULT_LIST
    do
        num=`grep $ret $TMP_API_FILE | wc -l`
        echo "nn::nfp::"${api}$'\t'${ret}$'\t'$num
        grep -v ${ret} $TMP_API_FILE > tmp
        mv -f tmp $TMP_API_FILE
    done
    cat $TMP_API_FILE >> $NOT_PARSE
    grep -v ${api}\(\) $TMP_FILE > tmp
    mv -f tmp $TMP_FILE
    rm -f $TMP_API_FILE
done

if [ -s $TMP_FILE ] ; then
    for api in $NOT_CHECK_API_LIST
    do
        sed -i -e "s/^nn::nfp::${api}\(.*\).*//g" $TMP_FILE
    done
    sed -i -e '/^$/d' $TMP_FILE
fi

if [ -s $TMP_FILE ] ; then
    echo "ERROR:Could not parse " $TMP_FILE >&2
    cat  $TMP_FILE >&2
else
    rm -f $TMP_FILE
fi

if [ -s $NOT_PARSE ] ; then
    echo "ERROR:Could not parse " $NOT_PARSE >&2
    cat  $NOT_PARSE >&2
else
    rm -f $NOT_PARSE
fi

