﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/oe.h>
#include <nn/nn_Common.h>
#include <nn/hid.h>
#include <nn/nn_Log.h>
#include <nn/os/os_Event.h>
#include <nn/hid/system/hid_Npad.h>
#include <nn/hid/hid_Npad.h>
#include <nn/hid/hid_NpadJoy.h>

#include <nnt/nntest.h>
#include <nnt/result/testResult_Assert.h>

#include <nnt/nfp/testNpt_Common.h>

//================================================================================
// 全プラットフォームで共通のテストスイートです。
// 必ずタグを設置せずにテストを開始してください。
//================================================================================

class NptAutoWithoutTag : public nnt::npt::TestFramework
{
protected:

    NptAutoWithoutTag() NN_NOEXCEPT
    {
        // oeライブラリを初期化します。実機のみ
#if defined(NN_BUILD_CONFIG_OS_HORIZON)
        nn::oe::Initialize();
#endif //defined(NN_BUILD_CONFIG_OS_HORIZON)
        // コントローラの初期化
        nnt::npt::InitializeHidController();
        // API呼び出しログ出力フラグ
        //nnt::npt::wrapper::SetApiCallLoggingMode(nnt::npt::wrapper::LogMode_Aging);
    }

    ~NptAutoWithoutTag() NN_NOEXCEPT
    {
    }

    virtual void SetUp() NN_NOEXCEPT NN_OVERRIDE
    {
    }

    virtual void TearDown() NN_NOEXCEPT NN_OVERRIDE
    {
        // 次のテストに影響が出ないようにライブラリを一旦終了しておきます。
        if(nnt::npt::wrapper::GetState() == nn::nfc::State_Init)
        {
            nnt::npt::FinalizeSystem();
        }
    }
};

//================================================================================
// テストスイート全体で共通の処理です。
//================================================================================

//================================================================================
// テストケースの実装です。
//================================================================================
TEST_F(NptAutoWithoutTag, TestCaseGoodOperationDeviceSearch)
{
    // デバイス状態がSearch時に呼び出すことができるAPIのテストをします。
    NN_LOG("TestCaseGoodOperationDeviceSearch start\n");

    // 状態をSearchに遷移させる
    nnt::npt::DoSearch();

    // ----------------------------------------
    // テスト対象 : nn::nfc::StopDetection()
    //              nn::nfc::GetDeviceState()
    //              nn::nfc::GetNpadId()
    //              nn::nfc::ListDevices()
    //              nn::nfc::AttachActivateEvent()
    //              nn::nfc::AttachDeactivateEvent()
    // ----------------------------------------
    EXPECT_EQ(nn::nfc::State_Init, nnt::npt::wrapper::GetState());
    EXPECT_EQ(nn::nfc::DeviceState_Search, nnt::npt::wrapper::GetDeviceState());
    nn::hid::NpadIdType npadId;
    NNT_EXPECT_RESULT_SUCCESS(nnt::npt::wrapper::GetNpadId(&npadId));
    nnt::npt::CheckNPadId(npadId);
    int outCount;
    nn::nfc::DeviceHandle currentDeviceHandle;
    NNT_EXPECT_RESULT_SUCCESS(
            nnt::npt::wrapper::ListDevices(&currentDeviceHandle, &outCount, 1));
    nn::os::SystemEventType activateEvent;
    nn::os::SystemEventType deactivateEvent;
    NNT_EXPECT_RESULT_SUCCESS(nnt::npt::wrapper::AttachActivateEvent(&activateEvent));
    NNT_EXPECT_RESULT_SUCCESS(nnt::npt::wrapper::AttachDeactivateEvent(&deactivateEvent));
    nn::os::DestroySystemEvent(&activateEvent);
    nn::os::DestroySystemEvent(&deactivateEvent);
    NNT_EXPECT_RESULT_SUCCESS(nnt::npt::wrapper::StopDetection());
    EXPECT_EQ(nn::nfc::State_Init, nnt::npt::wrapper::GetState());
    EXPECT_EQ(nn::nfc::DeviceState_Init, nnt::npt::wrapper::GetDeviceState());
}

TEST_F(NptAutoWithoutTag, TestCaseInvalidOperationDeviceSearch)
{
    // デバイス状態がSearch時に呼び出すことができるAPIのテストをします。
    NN_LOG("TestCaseInvalidOperationDeviceSearch start\n");

    // 状態をSearchに遷移させる
    nnt::npt::DoSearch();

    // ----------------------------------------
    // テスト対象 : nn::nfc::StartDetection()
    //              nn::nfc::SendCommandByPassThrough()
    //              nn::nfc::KeepPassThroughSession()
    //              nn::nfc::ReleasePassThroughSession()
    //              nn::nfc::GetTagInfo()
    // ----------------------------------------
    NNT_EXPECT_RESULT_FAILURE(nn::nfc::ResultInvalidDeviceState,
            nnt::npt::wrapper::StartDetection());
    // 送信データ(WRITE コマンド)
    nn::Bit8 sendWriteCommandData[6];
    // WRITE コマンドに対するレスポンスデータ
    size_t sendWriteCommandResponseDataSize;
    nn::Bit8 sendWriteCommandResponseData[1];
    nn::TimeSpan timeout = nn::TimeSpan::FromMilliSeconds(nnt::npt::SendCommandTimeout);
    nnt::npt::PrepareSendWriteCommandData(sendWriteCommandData, sizeof(sendWriteCommandData));
    nnt::npt::PrintSendWriteCommandData(sendWriteCommandData, sizeof(sendWriteCommandData));
    NNT_EXPECT_RESULT_FAILURE(nn::nfc::ResultInvalidDeviceState,
                              nnt::npt::wrapper::SendCommandByPassThrough(sendWriteCommandResponseData, &sendWriteCommandResponseDataSize,
                                                             sendWriteCommandData, sizeof(sendWriteCommandData),
                                                             sizeof(sendWriteCommandResponseData), timeout));
    NNT_EXPECT_RESULT_FAILURE(nn::nfc::ResultInvalidDeviceState,
                              nnt::npt::wrapper::KeepPassThroughSession());
    NNT_EXPECT_RESULT_FAILURE(nn::nfc::ResultInvalidDeviceState,
                              nnt::npt::wrapper::ReleasePassThroughSession());
    nn::nfc::TagInfo tagInfo;
    NNT_EXPECT_RESULT_FAILURE(nn::nfc::ResultInvalidDeviceState,
            nnt::npt::wrapper::GetTagInfo(&tagInfo));
}
