﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../Common/testNews_Common.h"

TEST(Subscribe, Initialize)
{
#if defined (NN_BUILD_CONFIG_OS_WIN)
    nn::time::Initialize();
    nn::nifm::Initialize();
#endif
}

TEST(Subscribe, Subscribe)
{
    EXPECT_RESULT_SUCCESS(nn::news::SetSubscriptionStatus("nx_promotion", nn::news::SubscriptionStatus_Subscribed));
    EXPECT_RESULT_SUCCESS(nn::news::SetSubscriptionStatus("nx_notice1", nn::news::SubscriptionStatus_AutoSubscribed));
    EXPECT_RESULT_SUCCESS(nn::news::SetSubscriptionStatus("nx_notice2", nn::news::SubscriptionStatus_Subscribed));
    EXPECT_RESULT_SUCCESS(nn::news::SetSubscriptionStatus("nx_promotion", nn::news::SubscriptionStatus_Unsubscribed));
    EXPECT_RESULT_SUCCESS(nn::news::SetSubscriptionStatus("nx_promotion", nn::news::SubscriptionStatus_Unsubscribed));

    nn::news::SubscriptionStatus status;

    EXPECT_RESULT_SUCCESS(nn::news::GetSubscriptionStatus(&status, "nx_promotion"));
    EXPECT_TRUE(status == nn::news::SubscriptionStatus_Unsubscribed);

    EXPECT_RESULT_SUCCESS(nn::news::GetSubscriptionStatus(&status, "nx_notice1"));
    EXPECT_TRUE(status == nn::news::SubscriptionStatus_AutoSubscribed);

    EXPECT_RESULT_SUCCESS(nn::news::GetSubscriptionStatus(&status, "nx_notice2"));
    EXPECT_TRUE(status == nn::news::SubscriptionStatus_Subscribed);
}

TEST(Subscribe, ImmediateRun)
{
    EXPECT_RESULT_SUCCESS(nn::news::SetSubscriptionStatus("nx_promotion", nn::news::SubscriptionStatus_Unconfigured));
    EXPECT_RESULT(nn::news::RequestImmediateReception("nx_promotion"),
        nn::news::ResultNotFound);

    EXPECT_RESULT_SUCCESS(nn::news::RequestImmediateReception("nx_notice1"));
    EXPECT_RESULT_SUCCESS(nn::news::RequestImmediateReception("nx_notice2"));
}

TEST(Subscribe, Clear)
{
    EXPECT_RESULT_SUCCESS(nn::news::ClearSubscriptionStatusAll());
    EXPECT_RESULT_SUCCESS(nn::news::ClearSubscriptionStatusAll());
}

TEST(Subscribe, Finalize)
{
#if defined (NN_BUILD_CONFIG_OS_WIN)
    nn::news::service::StopServer();
    nn::time::Finalize();
#endif
}
