﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../Common/testNews_Common.h"

// エージングテストを有効にするかどうか
#define ENABLE_AGING_TEST 1 // NOLINT(preprocessor/const)

TEST(StorageRaceCondition, Initialize)
{
    ASSERT_RESULT_SUCCESS(nnt::news::PostLocalNews("rom:/news.msgpack"));
}

TEST(StorageRaceCondition, MultipleDataOpen)
{
    nn::news::Database db;
    nn::news::NewsRecord record;
    int count;

    ASSERT_RESULT_SUCCESS(db.Open());
    ASSERT_RESULT_SUCCESS(db.GetList(&count, &record, "", "", 0, 1));

    nn::news::Data data1;
    ASSERT_RESULT_SUCCESS(data1.Open(record));

    nn::news::Data data2;
    ASSERT_RESULT_SUCCESS(data2.Open(record));

    db.Close();
}

TEST(StorageRaceCondition, MultipleDatabaseOpen)
{
    nn::news::Database db1;
    nn::news::Database db2;

    ASSERT_RESULT_SUCCESS(db1.Open());
    ASSERT_RESULT_SUCCESS(db2.Open());

    db2.Close();
    db1.Close();
}

TEST(StorageRaceCondition, Post)
{
    nn::news::Database db;
    nn::news::NewsRecord record;
    int count;

    ASSERT_RESULT_SUCCESS(db.Open());
    ASSERT_RESULT_SUCCESS(db.GetList(&count, &record, "", "", 0, 1));

    EXPECT_RESULT(nnt::news::PostLocalNews("rom:/news.msgpack"), nn::news::ResultLocked);

    nn::news::Data data;
    ASSERT_RESULT_SUCCESS(data.Open(record));

    EXPECT_RESULT(nnt::news::PostLocalNews("rom:/news.msgpack"), nn::news::ResultLocked);

    db.Close();

    EXPECT_RESULT(nnt::news::PostLocalNews("rom:/news.msgpack"), nn::news::ResultLocked);

    data.Close();

    EXPECT_RESULT_SUCCESS(nnt::news::PostLocalNews("rom:/news.msgpack"));
}

TEST(StorageRaceCondition, ClearStorage)
{
    nn::news::Database db;
    nn::news::NewsRecord record;
    int count;

    ASSERT_RESULT_SUCCESS(db.Open());
    ASSERT_RESULT_SUCCESS(db.GetList(&count, &record, "", "", 0, 1));

    EXPECT_RESULT(nn::news::ClearStorage(), nn::news::ResultLocked);

    nn::news::Data data;
    ASSERT_RESULT_SUCCESS(data.Open(record));

    EXPECT_RESULT(nn::news::ClearStorage(), nn::news::ResultLocked);

    db.Close();

    EXPECT_RESULT(nn::news::ClearStorage(), nn::news::ResultLocked);

    data.Close();

    EXPECT_RESULT_SUCCESS(nn::news::ClearStorage());
}

TEST(StorageRaceCondition, SetPassphrase)
{
    nn::news::Database db;
    nn::news::NewsRecord record;
    int count;

    ASSERT_RESULT_SUCCESS(db.Open());
    ASSERT_RESULT_SUCCESS(db.GetList(&count, &record, "", "", 0, 1));

    nn::ApplicationId appId = {0x0100000000001000};
    EXPECT_RESULT_SUCCESS(nn::news::SetPassphrase(appId, "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"));

    db.Close();
}

TEST(StorageRaceCondition, SetSubscriptionStatus)
{
    nn::news::Database db;
    nn::news::NewsRecord record;
    int count;

    ASSERT_RESULT_SUCCESS(db.Open());
    ASSERT_RESULT_SUCCESS(db.GetList(&count, &record, "", "", 0, 1));

    EXPECT_RESULT_SUCCESS(nn::news::SetSubscriptionStatus("topic_id", nn::news::SubscriptionStatus_Subscribed));
    EXPECT_RESULT_SUCCESS(nn::news::SetSubscriptionStatus("topic_id", nn::news::SubscriptionStatus_Unsubscribed));

    db.Close();
}

#if ENABLE_AGING_TEST == 1

TEST(StorageRaceCondition, Aging)
{
    EXPECT_RESULT_SUCCESS(nn::news::SetSubscriptionStatus("nx_news_sp_siglo04", nn::news::SubscriptionStatus_Subscribed));

    nn::news::Database db1;
    nn::news::Database db2;

    const int Interval = 100;

    // 約 2 分、DB Open と BG 処理を集中的に行う。
    for (int i = 0; i < 2 * 60 * (1000 / Interval); i++)
    {
        EXPECT_RESULT_SUCCESS(nn::news::RequestImmediateReception("nx_news_sp_siglo04"));
        ASSERT_RESULT_SUCCESS(db1.Open());
        ASSERT_RESULT_SUCCESS(db2.Open());

        db2.Close();
        db1.Close();

        EXPECT_RESULT_SUCCESS(nn::news::ClearStorage());

        nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(Interval));
    }

    EXPECT_RESULT_SUCCESS(nn::news::SetSubscriptionStatus("nx_news_sp_siglo04", nn::news::SubscriptionStatus_Unsubscribed));
}

#endif
