﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../Common/testNews_Common.h"

namespace
{
    nn::ApplicationId g_NewsAppId = {0x0100000000001000};
    const char* g_Passphrase = "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";

    nn::ApplicationId g_TargetAppId = {0x01003c700009c000};
}

TEST(AutoSubscription, Do)
{
    ASSERT_RESULT_SUCCESS(nn::news::ClearSubscriptionStatusAll());
    ASSERT_RESULT_SUCCESS(nn::news::SetPassphrase(g_NewsAppId, g_Passphrase));

    nn::nifm::Initialize();
    nn::nifm::SubmitNetworkRequestAndWait();

    ASSERT_TRUE(nn::nifm::IsNetworkAvailable());

    ASSERT_RESULT_SUCCESS(nn::news::RequestAutoSubscription(g_TargetAppId));

    NN_LOG("Sleep 20 seconds...\n");
    nn::os::SleepThread(nn::TimeSpan::FromSeconds(20));

    static nn::news::TopicId topicIds[nn::news::TopicCountMax];
    int count;

    ASSERT_RESULT_SUCCESS(nn::news::GetTopicList(&count, topicIds, NN_ARRAY_SIZE(topicIds),
        nn::news::SubscriptionStatusFilter_Subscribed));

    EXPECT_TRUE(count > 0);

    for (int i = 0; i < count; i++)
    {
        NN_LOG("TopicId[%03d] = %s\n", i, topicIds[i]);
    }
}
