﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nnt.h>
#include <nnt/nntest.h>
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/os.h>
#include <nn/fs.h>
#include <nn/fs/fs_SaveDataTypes.h>
#include <nn/time.h>
#include <nn/nifm.h>
#include <nn/nifm/nifm_NetworkConnection.h>
#include <nn/nifm/nifm_ApiRequest.h>
#include <nn/news.h>
#include <nn/news/news_Api.h>
#include <nn/news/news_ApiAdmin.h>
#include <nn/news/news_ApiDebug.h>
#include <nn/news/news_Data.h>
#include <nn/news/news_Database.h>
#include <nn/news/news_Result.h>
#include <nn/news/detail/news_TypesDetail.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/result/result_HandlingUtility.h>

#if defined (NN_BUILD_CONFIG_OS_WIN)
#include <nn/news/service/news_Server.h>
#endif

#include "testNews_Util.h"

#define EXPECT_RESULT_SUCCESS(exp) \
    do                                                                                      \
    {                                                                                       \
        nn::Result _r = (exp);                                                              \
                                                                                            \
        if (_r.IsFailure())                                                                 \
        {                                                                                   \
            NN_LOG(NN_MACRO_STRINGIZE(exp) " line = %d, module = %d, description = %d\n",   \
                __LINE__, _r.GetModule(), _r.GetDescription());                             \
        }                                                                                   \
        EXPECT_TRUE(_r.IsSuccess());                                                        \
    }                                                                                       \
    while (NN_STATIC_CONDITION(0))

#define EXPECT_RESULT_FAILURE(exp) \
    do                                                                                      \
    {                                                                                       \
        EXPECT_TRUE((exp).IsFailure());                                                     \
    }                                                                                       \
    while (NN_STATIC_CONDITION(0))

#define EXPECT_RESULT(exp, r) \
    do                                                                                      \
    {                                                                                       \
        nn::Result _r = (exp);                                                              \
                                                                                            \
        if (!r::Includes(_r))                                                               \
        {                                                                                   \
            NN_LOG(NN_MACRO_STRINGIZE(exp) " line = %d, module = %d, description = %d\n",   \
                __LINE__, _r.GetModule(), _r.GetDescription());                             \
        }                                                                                   \
        EXPECT_TRUE(r::Includes(_r));                                                       \
    }                                                                                       \
    while (NN_STATIC_CONDITION(0))

#define ASSERT_RESULT_SUCCESS(exp) \
    do                                                                                      \
    {                                                                                       \
        nn::Result _r = (exp);                                                              \
                                                                                            \
        if (_r.IsFailure())                                                                 \
        {                                                                                   \
            NN_LOG(NN_MACRO_STRINGIZE(exp) " line = %d, module = %d, description = %d\n",   \
                __LINE__, _r.GetModule(), _r.GetDescription());                             \
        }                                                                                   \
        ASSERT_TRUE(_r.IsSuccess());                                                        \
    }                                                                                       \
    while (NN_STATIC_CONDITION(0))

#define ASSERT_RESULT(exp, r) \
    do                                                                                      \
    {                                                                                       \
        nn::Result _r = (exp);                                                              \
                                                                                            \
        if (!r::Includes(_r))                                                               \
        {                                                                                   \
            NN_LOG(NN_MACRO_STRINGIZE(exp) " line = %d, module = %d, description = %d\n",   \
                __LINE__, _r.GetModule(), _r.GetDescription());                             \
        }                                                                                   \
        ASSERT_TRUE(r::Includes(_r));                                                       \
    }                                                                                       \
    while (NN_STATIC_CONDITION(0))
