﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <cstdio>

namespace NATF {
namespace Utils {
    int ReadLine(FILE* pFile, char* pBuffer, int bufferLen, bool dropWide) NN_NOEXCEPT
    {
        int bytesRead = 0;
        bool isDone = false;

        while(isDone == false)
        {
            auto ret = fread(&pBuffer[bytesRead], 1, 1, pFile);
            if(ret == 1)
            {
                printf("%c", pBuffer[bytesRead]);
                if(pBuffer[bytesRead] == '\n' || pBuffer[bytesRead] == '\r')
                {
                    pBuffer[bytesRead] = '\0';
                    isDone = true;
                }

                ++bytesRead;

                if(dropWide)
                {
                    char waste = 0;
                    fread(&waste, 1, 1, pFile);
                }
            }
            else
            {
                return -1;
            }

            if(feof(pFile))
            {
                if(bytesRead >= bufferLen)
                {
                    return -1;
                }

                pBuffer[bytesRead] = '\0';
                ++bytesRead;
                break;
            }

            if(bytesRead >= bufferLen)
            {
                return -1;
            }
        }

        return bytesRead;
    }
} // namespace Utils
} // namespace NATF
