﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*
 Test process for Network
 *---------------------------------------------------------------------------*/

#include "NetTest_Port.h"

#include "Tests/SslHttpsDownloadMultiTest.h"
#include "Utils/CommandLineParser.h"

#include <nnt/nntest.h>

namespace
{
const uint32_t MaxVerifyOptionLen = 16;

bool VerifyOptionFromString(const char* pStr, nn::ssl::Connection::VerifyOption& verifyOption) NN_NOEXCEPT
{
    if( strcmp(pStr, "NONE") == 0 )
    {
        verifyOption = nn::ssl::Connection::VerifyOption::VerifyOption_None;
    }
    else if( strcmp(pStr, "PEERCA") == 0 )
    {
        verifyOption = nn::ssl::Connection::VerifyOption::VerifyOption_PeerCa;
    }
    else if( strcmp(pStr, "HOSTNAME") == 0 )
    {
        verifyOption = nn::ssl::Connection::VerifyOption::VerifyOption_HostName;
    }
    else if( strcmp(pStr, "DATECHECK") == 0 )
    {
        verifyOption = nn::ssl::Connection::VerifyOption::VerifyOption_DateCheck;
    }
    else if( strcmp(pStr, "ALL") == 0 )
    {
        verifyOption = nn::ssl::Connection::VerifyOption::VerifyOption_All;
    }
    else
    {
        NN_NETTEST_LOG(" Failed to parse --VerifyOption. Valid values: None, PeerCa, HostName, DateCheck, All\n\n");
        return false;
    }

    return true;
}
}

// SslHttpsDownloadMulti
TEST(natf, SslHttpsDownloadMulti)
{
    bool isSuccess;
    NATF::Utils::ParserGroup parser;
    int argc;
    uint16_t defaultPortNum = 443;
    uint16_t portNum = 0;
    uint32_t timeoutMs = 0;
    MD5Hash::Result expectedHash;
    nn::ssl::Connection::VerifyOption verifyOption;
    const char* pDefaultVerifyOption="All";
    const char * const * pArgv;

    uint32_t connectionCount;
    nn::util::Uuid netProfile;
    char pHostName[NATF::Tests::SslHttpsDownloadMulti::MaxHostNameLen];
    char pResource[NATF::Tests::SslHttpsDownloadMulti::MaxResourceLen];
    char pVerifyOption[MaxVerifyOptionLen];
    char pTestName[NATF::BaseTest::NameBufferLen];

    NN_NETTEST_LOG("\nEnter NATF Process\n\n");

    NETTEST_GET_ARGS(argc, pArgv);

    parser.AddParser(NATF::Utils::StringParser ("--Name", nullptr, pTestName, sizeof(pTestName)));
    parser.AddParser(NATF::Utils::UInt32Parser ("--ConnectionCount", nullptr, connectionCount));
    parser.AddParser(NATF::Utils::UuidParser   ("--NetProfile", &nn::util::InvalidUuid, netProfile));
    parser.AddParser(NATF::Utils::StringParser ("--HostName", nullptr, pHostName, sizeof(pHostName)));
    parser.AddParser(NATF::Utils::StringParser ("--Resource", nullptr, pResource, sizeof(pResource)));
    parser.AddParser(NATF::Utils::UInt16Parser ("--PortNum", &defaultPortNum, portNum));
    parser.AddParser(NATF::Utils::UInt32Parser ("--TimeoutMs", nullptr, timeoutMs));
    parser.AddParser(NATF::Utils::StringParser ("--VerifyOption", pDefaultVerifyOption, pVerifyOption, sizeof(pVerifyOption)));
    parser.AddParser(NATF::Utils::Md5HashParser("--Md5Hash", nullptr, expectedHash));

    if( !parser.Parse(argc, pArgv) )
    {
        NN_NETTEST_LOG(" * Failed to parse command line arguements!\n\n");
        EXPECT_EQ(false, true);
        return;
    }

    // Make option case-insensitive
    NetTest::StrUpr(pVerifyOption);

    if( !VerifyOptionFromString(pVerifyOption, verifyOption) )
    {
        EXPECT_EQ(false, true);
        return;
    }

    NATF::Tests::SslHttpsDownloadMulti sslHttpsDownloadMulti(pTestName, netProfile, timeoutMs, connectionCount, pHostName, portNum, pResource, verifyOption, expectedHash);

    isSuccess = sslHttpsDownloadMulti.Run();
    EXPECT_EQ(isSuccess, true);

    NN_NETTEST_LOG("\nExit NATF Process\n\n");
}
