﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*
 Test process for Network
 *---------------------------------------------------------------------------*/

#include "NetTest_Port.h"

#include "Tests/HttpServerTest_Win.h"
#include "Utils/CommandLineParser.h"

#include <nnt/nntest.h>

// HttpServer
TEST(natf, HttpServer)
{
    bool isSuccess;
    NATF::Utils::ParserGroup parser;
    int argc;
    uint16_t defaultPortNum = 80;
    uint32_t defaultDuration = 60;
    uint32_t defaultCpuFreq = 0;
    bool defaultUseSsl = false;
    uint32_t durationSec = 0;
    uint32_t cpuFreqMs = 0;
    uint16_t portNum = 0;
    bool useSsl = false;
    bool defaultAuthClient = false;
    bool authClient = defaultAuthClient;
    bool defaultQuitOnError = false;
    bool quitOnError = defaultQuitOnError;
    char pTestName[NATF::BaseTest::NameBufferLen];
    const char * const * pArgv;

    NN_NETTEST_LOG("\nEnter NATF Process\n\n");

    NETTEST_GET_ARGS(argc, pArgv);

    parser.AddParser(NATF::Utils::StringParser  ("--Name", "HttpServer", pTestName, sizeof(pTestName)));
    parser.AddParser(NATF::Utils::UInt32Parser ("--DurationSec", &defaultDuration, durationSec));
    parser.AddParser(NATF::Utils::UInt16Parser ("--PortNum", &defaultPortNum, portNum));
    parser.AddParser(NATF::Utils::BoolParser   ("--UseSsl", &defaultUseSsl, useSsl));
    parser.AddParser(NATF::Utils::BoolParser   ("--AuthClient", &defaultAuthClient, authClient));
    parser.AddParser(NATF::Utils::UInt32Parser ("--CpuUsageFreq", &defaultCpuFreq, cpuFreqMs));
    parser.AddParser(NATF::Utils::BoolParser   ("--QuitOnFail", &defaultQuitOnError, quitOnError));

    if (!parser.Parse(argc, pArgv))
    {
        NN_NETTEST_LOG(" * Failed to parse command line arguements!\n\n");
        EXPECT_EQ(false, true);
        return;
    }

    NATF::Tests::HttpServer httpServer(pTestName, useSsl, durationSec, portNum, cpuFreqMs, authClient, quitOnError);

    isSuccess = httpServer.Run();
    EXPECT_EQ(isSuccess, true);

    NN_NETTEST_LOG("\nExit NATF Process\n\n");
}
