﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*
 Test process for Network
 *---------------------------------------------------------------------------*/

#include <nnt/nntest.h>
#include <nn/os.h>
#include <nn/nn_Log.h>

namespace // unnamed, for constants accessible only to this file
{
    const int TestSleepTimeSec = 17;
}



// HelloWorld
TEST(natf, HelloWorld)
{
    NN_LOG("\nHello World 1 - start\n");

    NN_LOG("\nHello World 1 - Sleeping %ds!\n", TestSleepTimeSec);
    nn::os::SleepThread(nn::TimeSpan::FromSeconds(TestSleepTimeSec));

    NN_LOG("\nHello World 1 - end\n\n");
}

