﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifdef NN_NINTENDO_SDK
#pragma once
/*
  mntcpapp.h: TCP Stub Server Application include file (9.18EA).

  Copyright (c) Ixia 2002-2009
  All rights reserved.

*/
#endif

#define _MNTCPAPP_SOMEIP_H_

#define FORM_SET_FIELD(form,field,value) \
    ((form)->field) = (value); ((form)->field##OK) = TRUE

#define FORM_UNSET_FIELD(form,field) ((form)->field##OK) = FALSE

#define FORM_SET_DATA(form,value,len) \
    ((form)->data) = (value); ((form)->dataLen) = (len); \
    ((form)->dataOK) = ((form)->dataLenOK) = TRUE

#define FORM_SET_VARFIELD(form,field,value,len) \
    ((form)->field) = (value); ((form)->field##Len) = (len); \
    ((form)->field##OK) = ((form)->field##LenOK) = TRUE

#define FORM_FIELD_DEF(form,field,deflt) \
    if(((form)->field##OK) == FALSE){ \
      ((form)->field) = (deflt); \
      ((form)->field##OK) = TRUE; \
    }

#define FORM_VARFIELD_COPY_DEF(form,field,value,len) \
        if(((form)->field##OK) == FALSE){ \
        MemMove((void *)((form)->field),(void *)value,len); \
        ((form)->field##OK) = TRUE; \
        }


#define FORM_VARFIELD_COPY_SET(form,field,value,len) \
        MemMove((void *)((form)->field),(void *)value,len); \
        ((form)->field##OK) = TRUE

#define FORM_DATA_DEF(form,value,len) \
    FORM_FIELD_DEF(form,data,value); \
    FORM_FIELD_DEF(form,dataLen,len)

#define FORM_VARFIELD_DEF(form,field,value,len) \
     FORM_FIELD_DEF(form,field,value); \
    FORM_FIELD_DEF(form,field##Len,len)

#define FORM_FIELD_CMP_NUM(control,form,field) \
    (boolean)(((control)->field##OK)? \
              (((control)->field == (form)->field)):\
              TRUE)

#define FORM_FIELD_CMP_STR(control,form,field,len) \
    (boolean)(((control)->field##OK)? \
              (!MemCmp((void *)((control)->field), \
                       (void *)((form)->field),len)):\
              TRUE)

#define STUB_SOMEIP_HDR_LEN_MIN_VAL 8 /* This is minimal value of length field */  // NOLINT

#define STUB_MAJOR_VERSION 0x01           // NOLINT
#define STUB_MINOR_VERSION 0x00           // NOLINT
#define STUB_SERVICE_ID 0x0105            // NOLINT
#define STUB_PROTOCOL_VERSION 0x01        // NOLINT
#define STUB_INTERFACE_VERSION 0x01       // NOLINT

#define STUB_MSG_TYPE_REQUEST 0x00        // NOLINT
#define STUB_MSG_TYPE_RESPONSE 0x80       // NOLINT
#define STUB_MSG_TYPE_EVENT 0x02          // NOLINT

#define MN_SOMEIP_ERR_E_OK       0x00                                           // NOLINT
#define MN_SOMEIP_ERR_E_NOK      0x01 //General error                           // NOLINT
#define MN_SOMEIP_ERR_E_NTF      0xFF // SP Not Found                           // NOLINT
#define MN_SOMEIP_ERR_E_PEN      0xFE // Upeer Tester or SP Pending             // NOLINT
#define MN_SOMEIP_ERR_E_ISB      0xFD // Insufficient Buf Size                  // NOLINT
#define MN_SOMEIP_ERR_E_ISD      0xEF // Invalid Socket Id                      // NOLINT
#define MN_SOMEIP_ERR_E_UCS      0xEE // Unable to create socket                // NOLINT
#define MN_SOMEIP_ERR_E_UBS      0xED // unable to bind socket                  // NOLINT
#define MN_SOMEIP_ERR_E_INV      0xFC // invalid input or parameter             // NOLINT
#define MN_SOMEIP_ERR_E_TCP_PNA  0xEB // TCP Error: precedence not allowed      // NOLINT
#define MN_SOMEIP_ERR_E_TCP_FSU  0xEA // TCP Error: foreign socket unspecified  // NOLINT
#define MN_SOMEIP_ERR_E_TCP_ILP  0xE9 // TCP Error: connection illegal for this process     // NOLINT
#define MN_SOMEIP_ERR_E_TCP_INR  0xE8 // TCP Error: insufficient resources      // NOLINT
#define MN_SOMEIP_ERR_E_TCP_CAE  0xE7 // TCP Error: connection already exists   // NOLINT
#define MN_SOMEIP_ERR_E_TCP_COC  0xE6 // TCP Error: connection closing          // NOLINT
#define MN_SOMEIP_ERR_E_TCP_CNE  0xE5 // TCP Error: connection does not exists  // NOLINT
#define MN_SOMEIP_ERR_E_TCP_CRE  0xE4 // TCP Error: connection reset            // NOLINT
#define MN_SOMEIP_ERR_E_TCP_CAT  0xE3 // TCP Error: connection aborted due to user timeout     // NOLINT
#define MN_SOMEIP_ERR_E_TCP_COR  0xE2 // TCP Error: connection refused          // NOLINT

#define MN_SOMEIP_ERR_E_TRY_AGAIN 0x11 // This not something spec defined.      // NOLINT

enum MNTCPStubSomeIpGID_e {
    MN_STUB_SOMEIP_GID_GEN = 0,
    MN_STUB_SOMEIP_GID_UDP,
    MN_STUB_SOMEIP_GID_TCP
};
typedef enum MNTCPStubSomeIpGID_e MNTCPStubSomeIpGID_t;

enum MNTCPStubSomeIpGenPID_e {
    MN_STUB_SOMEIP_GEN_PID_GET_VERSION = 1,
    MN_STUB_SOMEIP_GEN_PID_START_TEST,
    MN_STUB_SOMEIP_GEN_PID_END_TEST
};
typedef enum MNTCPStubSomeIpGenPID_e MNTCPStubSomeIpGenPID_t;

enum MNTCPStubSomeIpPID_e {
    MN_STUB_SOMEIP_PID_CLOSE_SOCKET = 0,
    MN_STUB_SOMEIP_PID_CREATE_N_BIND,
    MN_STUB_SOMEIP_PID_SEND_DATA,
    MN_STUB_SOMEIP_PID_RCV_N_FWD,
    MN_STUB_SOMEIP_PID_LISTEN_N_ACCEPT,
    MN_STUB_SOMEIP_PID_CONNECT,
    MN_STUB_SOMEIP_PID_CONF_SOCKET,
    MN_STUB_SOMEIP_PID_SHUTDOWN,
    MN_STUB_SOMEIP_PID_MAX = 0xff
};
typedef enum MNTCPStubSomeIpPID_e MNTCPStubSomeIpPID_t;

enum MNTCPStubSomeIpSockOpt_e {
    MN_STUB_SOMEIP_SOCKOPT_SET_TTL = 0,
    MN_STUB_SOMEIP_SOCKOPT_SET_PRIORITY,
    MN_STUB_SOMEIP_SOCKOPT_SET_DFBIT,
    MN_STUB_SOMEIP_SOCKOPT_SET_TIMESTAMP,
    MN_STUB_SOMEIP_SOCKOPT_SET_IPTOS,
    MN_STUB_SOMEIP_SOCKOPT_SET_MSS,
    MN_STUB_SOMEIP_SOCKOPT_SET_ENDIS_NAGGLE,
    MN_STUB_SOMEIP_SOCKOPT_SET_ENDIS_UDPCHKSUM,
//  SOCKOPT_ILLEGAL = 0,
//
//  /* The following are of type SOL_SOCKET */
//  SOCKOPT_SET_LINGER_TIME,
//  SOCKOPT_SET_OOB_DATA_INLINE,
//  SOCKOPT_SET_RECV_BUF_SIZE,
//  SOCKOPT_SET_SEND_BUF_SIZE,
//
//  /* The followings are of type IPPROTO_TCP */
//  SOCKOPT_SET_NAGGLE_ALGO,
//  SOCKOPT_SET_MSS,
//  SOCKOPT_SET_DFBIT,
//  SOCKOPT_SET_STDURG,
//  SOCKOPT_SET_NOPUSH,
//
//  /* The followings are of type IPPROTO_IP */
//  SOCKOPT_SET_TTL,
//#ifdef 1
//  SOCKOPT_SET_HOPLIMIT,
//#endif /* LIB_IPV6 */
//  SOCKOPT_GET_ERROR,
//  SOCKOPT_GET_RECV_BUF,
//  SOCKOPT_GET_STDURG,
//  SOCKOPT_GET_OOB_DATA_INLINE,
//
//  SOCKOPT_SET_MD5,
//  SOCKOPT_GET_MD5
};
typedef enum MNTCPStubSomeIpSockOpt_e MNTCPStubSomeIpSockOpt_t;

/* special global variable */
ubyte udpStubIPVersion;

/******************************************************************
 *                                                                *
 *            STUB NEW CODE as per AUTOSAR                        *
 *                                                                *
 *****************************************************************/

struct StubSomeipHdrForm_s {
    ubyte2 serviceId; /* ServiceID(16 bit) 0 bit MethodID(15 bit) */
    ubyte eventBit;
    ubyte gid;
    ubyte pid;
    ubyte4 length;
    ubyte4 reqID; /* ClientID(16 bit) 0 bit SessionID(15 bit) */
    ubyte protoVer;
    ubyte intfVer;
    ubyte msgType;
    ubyte retCode;

    boolean  serviceIdOK;
    boolean  eventBitOK;
    boolean  gidOK;
    boolean  pidOK;
    boolean  lengthOK;
    boolean  reqIDOK;
    boolean  protoVerOK;
    boolean  intfVerOK;
    boolean  msgTypeOK;
    boolean  retCodeOK;

    boolean isMalformed;    /* Not a part of the form */
    ubyte *malData;         /* Used when malformed */
    ubyte4 malDataLen;      /* Advertisement message */
    boolean malDataOK;      /* received */
    boolean malDataLenOK;
};
typedef struct StubSomeipHdrForm_s StubSomeipHdrForm_t;

struct StubSomeipForm_s {
    StubSomeipHdrForm_t *stubSomeipHdr;

    /* payload form will depend on SOME-IP Msg Type */
    void *payload;
    ubyte4 payloadLen;

    boolean stubSomeipHdrOK;
    boolean payloadOK;
    boolean payloadLenOK;

    boolean isMalformed;    /* Not a part of the form */
    ubyte *malData;         /* Used when malformed */
    ubyte4 malDataLen;      /* Advertisement message */
    boolean malDataOK;      /* received */
    boolean malDataLenOK;
};
typedef struct StubSomeipForm_s StubSomeipForm_t;

struct StubSomeipFormContainer_s {
    StubSomeipForm_t *someipForm;
    struct StubSomeipFormContainer_s *next;
};
typedef struct StubSomeipFormContainer_s StubSomeipFormContainer_t;

enum StubDataItem_e {
    STUB_SOMEIP_SEND_MSG_TYPE = 0,
    STUB_SOMEIP_SERVICE_ID,
    STUB_SOMEIP_GID,
    STUB_SOMEIP_PID,

    STUB_LAST_ITEM
};
typedef enum StubDataItem_e StubDataItem_t;

enum StubGIDItem_e {
    SP_GID_GENERAL = 0,
    SP_GID_UDP = 1,
    SP_GID_TCP = 2,
    SP_GID_ICMP = 3,
    SP_GID_ICMPV6 = 4,
    SP_GID_IP = 5,
    SP_GID_IPV6 = 6,
    SP_GID_DHCP = 7,
    SP_GID_DHCPV6 = 8,
    SP_GID_ARP = 9,
    SP_GID_NDP = 10,

    SP_GID_LAST
};
typedef enum StubGIDItem_e StubGIDItem_t;

enum StubGeneralPIDItem_e {
    SP_GEN_GET_VERSION = 1,
    SP_GEN_START_TEST = 2,
    SP_GEN_END_TEST = 3,

    SP_GEN_LAST
};
typedef enum StubGeneralPIDItem_e StubGeneralPIDItem_t;

enum StubUDPPIDItem_e {
    SP_UDP_CLOSE_SOCKET = 0,
    SP_UDP_CREATE_AND_BIND = 1,
    SP_UDP_SEND_DATA = 2,
    SP_UDP_RECEIVE_AND_FORWARD = 3,
    SP_UDP_CONFIG_SOCKET = 6,
    SP_UDP_SHUTDOWN = 7,

    SP_UDP_LAST
};
typedef enum StubUDPPIDItem_e StubUDPPIDItem_t;

enum StubTCPPIDItem_e {
    SP_TCP_CLOSE_SOCKET = 0,
    SP_TCP_CREATE_AND_BIND = 1,
    SP_TCP_SEND_DATA = 2,
    SP_TCP_RECEIVE_AND_FORWARD = 3,
    SP_TCP_LISTEN_AND_ACCEPT = 4,
    SP_TCP_CONNECT = 5,
    SP_TCP_CONFIG_SOCKET = 6,
    SP_TCP_SHUTDOWN = 7,

    SP_TCP_LAST
};
typedef enum StubTCPPIDItem_e StubTCPPIDItem_t;

enum StubSocketConfigItem_e {
    SP_SOCKET_CONFIGURE_TTL = 0x0000,
    SP_SOCKET_CONFIGURE_PRIORITY,

    SP_SOCKET_CONF_LAST
};
typedef enum StubSocketConfigItem_e StubSocketConfigItem_t;

enum StubResultIdItem_e {
    SP_ERROR_E_OK = 0x00,
    SP_ERROR_E_NOK = 0x01,
    SP_ERROR_E_NTF = 0xFF,
    SP_ERROR_E_PEN = 0xFE,
    SP_ERROR_E_ISB = 0xFD,
    SP_ERROR_E_ISD = 0xEF,
    SP_ERROR_E_UCS = 0xEE,
    SP_ERROR_E_UBS = 0xED,
    SP_ERROR_E_INV = 0xEC,
    SP_ERROR_MAX
};
enum StubResultIdItem_e StubResultIdItem_t;

/***************** SOMEIP Stub Command Payload *****************/
struct StubSomeipStartEndTest_s{
    ubyte2 tcId;
    ubyte *tsName;
};
typedef struct StubSomeipStartEndTest_s StubSomeipStartEndTest_t;

struct StubSomeipVersionCtx_s {
    ubyte2 majVer;
    ubyte2 minVer;
};
typedef struct StubSomeipVersionCtx_s StubSomeipVersionCtx_t;

struct StubSomeipCloseSocket_s {
    ubyte2 socketId;
    ubyte abort;
};
typedef struct StubSomeipCloseSocket_s StubSomeipCloseSocket_t;

typedef StubSomeipCloseSocket_t StubSomeipShutDwnSocket_t;

struct StubSomeipCreateAndBind_s {
    ubyte doBind;
    ubyte2 localPort;
    ubyte2 addrLen;
    ubyte16 localAddr;
};
typedef struct StubSomeipCreateAndBind_s StubSomeipCreateAndBind_t;

struct SOMEIPStubListenAndAcceptReqCtx_s {
    ubyte2 listSockId;
    ubyte2 maxCon;
};
typedef struct SOMEIPStubListenAndAcceptReqCtx_s SOMEIPStubListenAndAcceptReqCtx_t;

struct SOMEIPStubListenAndAcceptEvntCtx_s {
    ubyte2 listSockId;
    ubyte2 newSockId;
    ubyte2 port;
    ubyte2 addrLen;
    ubyte16 addr;
};
typedef struct SOMEIPStubListenAndAcceptEvntCtx_s SOMEIPStubListenAndAcceptEvntCtx_t;

struct SOMEIPStubConnectReqCtx_s {
    ubyte2 socketId;
    ubyte2 destPort;
    ubyte2  addrLen;
    ubyte16 destAddr;
};
typedef struct SOMEIPStubConnectReqCtx_s SOMEIPStubConnectReqCtx_t;

struct SOMEIPStubSendDataCtx_s {
    ubyte2 sockId;
    ubyte2 totalLen;
    ubyte2 dstPort;
    ubyte2 addrLen;
    ubyte4 dstAddr;
    ubyte  flags;
    ubyte2 dataLen;
    ubyte  *data;
};
typedef struct SOMEIPStubSendDataCtx_s SOMEIPStubSendDataCtx_t;

struct SOMEIPStubRcvNFwdReqCtx_s {
    ubyte2 sockId;
    ubyte2 maxFwd;
    ubyte2 maxLen;
};
typedef struct SOMEIPStubRcvNFwdReqCtx_s SOMEIPStubRcvNFwdReqCtx_t;

struct SOMEIPStubRcvNFwdRespCtx_s {
    ubyte2 dropCnt;
};
typedef struct SOMEIPStubRcvNFwdRespCtx_s SOMEIPStubRcvNFwdRespCtx_t;

struct SOMEIPStubRcvNFwdEvntCtx_s {
    ubyte2 fullLen;
    ubyte2 srcPort;
    ubyte4 srcAddr;
    ubyte2 dataLen;
    ubyte  *payload;
};
typedef struct SOMEIPStubRcvNFwdEvntCtx_s SOMEIPStubRcvNFwdEvntCtx_t;

struct SOMEIPStubConfSocketCtx_s {
    ubyte2 sockId;
    ubyte2 paramId;
    ubyte2 paramLen;
    ubyte  paramVal[0xFFFF];
};
typedef struct SOMEIPStubConfSocketCtx_s SOMEIPStubConfSocketCtx_t;

extern StubSomeipHdrForm_t *StubSomeipHdrFormCreate(void);
extern StubSomeipForm_t *StubSomeipFormCreate(ubyte2 msgType, ubyte gid, ubyte pid);


extern void StubSomeipHdrFormDestroy(StubSomeipHdrForm_t *form);
extern void StubSomeipFormDestroy(StubSomeipForm_t *form);

extern byte4
StubSomeipHdrFormBuild(StubSomeipHdrForm_t *form, ubyte *buffer);
extern byte4
StubSomeipFormBuild(StubSomeipForm_t *form, ubyte *buffer);

extern byte4
StubSomeipHdrToForm(StubSomeipHdrForm_t **form, ubyte *buffer, byte4 bufferLen);
extern byte4
StubSomeipToForm(StubSomeipForm_t **form, ubyte *buffer, byte4 bufferLen);
/*
void StubSomeipStartEndTestEncode(StubSomeipStartEndTest_t *form);
void StubSomeipVersionCtxEncode(StubSomeipVersionCtx_t *form);
void StubSomeipCloseSocketEncode(StubSomeipCloseSocket_t *form);
void StubSomeipCreateAndBindEncode(StubSomeipCreateAndBind_t *form);
void SOMEIPStubListenAndAcceptReqCtxEncode(SOMEIPStubListenAndAcceptReqCtx_t *form);
void SOMEIPStubListenAndAcceptEvntCtxEncode(SOMEIPStubListenAndAcceptEvntCtx_t *form);
*/
