﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Net.Sockets;
using System.Threading;
using System.IO;

using Nintendo.Htcs;

namespace HtcsHostApp
{
    internal class Program
    {


        private static HtcsCommunicator m_HtcsCommunicator = new HtcsCommunicator();
        private static TargetList m_TargetList;
        private static PortMap m_PortMap;
        private static AutoResetEvent m_FindServerEvent = new AutoResetEvent(false);
        private const string TargetServerPortName = "DhcpTestController";

        private static void SendCommand(TcpClient client,string[] args)
        {

            using (var sw = new StreamWriter(client.GetStream(), Encoding.ASCII, 1024, true))
            {
                //sw.Write(args[0].ToLower());
                foreach (string arg in args)
                {
                    sw.Write(arg);
                    sw.Write("\n");
                }
                sw.Flush();
            }

        }
        private static void ControllerClient(string[] args)
        {
            // HTCS ポート名が TargetServerPortName で表されるサーバが開くまで待機
            m_FindServerEvent.WaitOne();

            // HTCS ポート名が TargetServerPortName のもののうち、最初に見つかったものを取得
            //   複数のターゲットが同名の HTCS ポートを開いている場合は、
            //   PortMapItem.HtcsPortDescriptor.HtcsPortName で取得できるターゲット名で識別してください
            PortMapItem portMapItem = m_PortMap.First(x => x.HtcsPortDescriptor.HtcsPortName == TargetServerPortName);

            // TCP ソケットを作成、EndPoint 情報を基に Connect
            TcpClient client = new TcpClient();

            try
            {
                client.Connect(portMapItem.EndPoint);
            }
            catch (SocketException ex)
            {
                Console.WriteLine("Socket Exception Error Code :{0}\n", ex.ErrorCode);
                return;
            }



            Console.WriteLine("Connected to server on target.");

            SendCommand(client, args);
            Console.WriteLine("Sent Command {0}\n",args[0]);
            // ソケットをクローズ
            client.Close();

            Console.WriteLine("Closed.");
        }

        private static void Main(string[] args)
        {
            Console.Write("Passed Args: ");
            foreach(string arg in args)
            {
                Console.Write("{0} ", arg);
            }
            Console.Write("\n");

            // HtcsInfo が更新されたときに呼ばれる関数を登録
            //   HtcsInfo リスト表示関数の登録
          //  m_HtcsCommunicator.HtcsInfoUpdated += PrintHtcsInfo;
            //   HtcsInfo 内のポートマッピングに、接続予定のポートが追加されたかをチェックする関数の登録
            m_HtcsCommunicator.HtcsInfoUpdated += CheckHtcsInfo;

            // TargetManager への接続が確立されるまでループ
            if (m_HtcsCommunicator.Start() == false)
            {
                Console.WriteLine("Failed connecting to TargetManager!");
                return;
            }

            ControllerClient(args);

            m_HtcsCommunicator.Stop();

        }

        private static void CheckHtcsInfo(object sender, HtcsInfoUpdatedEventArgs e)
        {
            // HtcsInfo のキャッシュを更新
            m_TargetList = e.TargetList;
            m_PortMap = e.PortMap;

            // ポート名が TargetServerPortName のポートが開かれていたら通知を投げる
            if (e.PortMap.Any(x => x.HtcsPortDescriptor.HtcsPortName == TargetServerPortName))
            {
                m_FindServerEvent.Set();
            }
        }

        private static void PrintHtcsInfo(object sender, HtcsInfoUpdatedEventArgs e)
        {
            Console.WriteLine("-  TargetList -");
            foreach (Target item in e.TargetList)
            {
                Console.WriteLine(item.ToString());
            }
            Console.WriteLine("---------------");
            Console.WriteLine("--- PortMap ---");
            foreach (PortMapItem item in e.PortMap)
            {
                Console.WriteLine(item.ToString());
            }
            Console.WriteLine("---------------");
        }
    }
}
