﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

//////////////////////////////////////////////////////////////
// DEFAULT: ENABLE_FAILING_TESTS - DISABLED
//
// #define ENABLE_FAILING_TESTS

#include "testNet_ApiCommon.h"
#include "Unit/testNet_ApiUnitCommon.h"

#include <cstdio>     // sprintf
#include <cctype>     // isprint
#include <cstdlib>    // malloc

#include <nn/os.h>
#include <nn/nn_Log.h>

#include <nn/socket.h>
#include <nnt/nntest.h>

#include <nn/os/os_Thread.h>
#include <nn/nifm.h>

#include "Unit/testNet_ThreadedTest.h"          // Threads for testing
#include "Unit/testNet_LoopbackDnsServer.h"     // Loopback DNS

#include <nn/socket/socket_ApiPrivate.h>

#ifndef NN_BUILD_CONFIG_OS_WIN32
#include <nn/socket/resolver/resolver_Client.h>
#endif

namespace NATF {
namespace API {

//*********************
//*  G L O B A L S
//*********************


static bool
InitializeTesting()
{
    nn::Result                result;
    bool                      isSuccess = true;

    NN_LOG( "In\n\n" );

    ///////////////////////////
    //// Test Counts: Initialize
    ///////////////////////////

    INITIALIZE_TEST_COUNTS;

    ///////////////////////////
    //// NIFM Library: Initialize
    ///////////////////////////

    ERROR_IF(!NATF::API::TestSetup(NATF::API::TestSetupOptions_Nifm | NATF::API::TestSetupOptions_Socket), "TestSetup failed.");

    // NIFM: Network Interface is Online
    NN_LOG( "====================================\n" );
    NN_LOG( "NIFM: Network ===>  O N L I N E <===\n" );
    NN_LOG( "====================================\n" );

    return( true );

out:

    return( false );
}



static bool
CallGetHostByName( const char * in_domainname )
{
    nn::socket::HostEnt * respHosts;
    nn::socket::InAddr ** addr_list;
    int                 idx;

    respHosts = nn::socket::GetHostEntByName( in_domainname );
    if ( respHosts == nullptr )
    {
        NN_LOG( "nn::socket::GetHostByName() Failed with: errno: %d, h_errno: %d, hstrerror: %s\n",
                 nn::socket::GetLastError(), *(nn::socket::GetHError() ),
                 nn::socket::HStrError(  *(nn::socket::GetHError() ) ) );
        goto out;
    }
    else
    {
        NN_LOG( "Host name       : [%s]\n", respHosts->h_name );
        NN_LOG( "Address Type    : [%d]\n", respHosts->h_addrtype );
        NN_LOG( "Len of Addr     : [%d]\n", respHosts->h_length );

        for(idx = 0; respHosts->h_aliases[idx] != NULL; idx++)
        {

           NN_LOG( "Alias: [%s]\n", respHosts->h_aliases[idx] );
        }

        addr_list = (nn::socket::InAddr **) respHosts->h_addr_list;
        for(idx = 0; addr_list[idx] != NULL; idx++)
        {

           NN_LOG( "IP Address: [%s]\n", nn::socket::InetNtoa( (*addr_list[idx] ) ) );
        }

        NN_LOG( "There are a total of [%d] IPv4 Addresses\n", idx );
    }

    return( true );

out:

    return( false );
}


static bool
CallGetHostByAddr( const char *    in_ipAddr )
{
    nn::socket::InAddr      ipv4Addr;
    nn::socket::HostEnt *    respHosts = NULL;
    nn::socket::InAddr **   addr_list = NULL;
    int                 idx = 0, rc = 0;
    bool                isSuccess = true;

    // Translate Target IP Address into Lookup Address
    rc = nn::socket::InetPton( nn::socket::Family::Af_Inet, in_ipAddr, &ipv4Addr );
    ERROR_IF( rc != 1, "InetPton() Failed but Success was expected!" );

    respHosts = nn::socket::GetHostEntByAddr( &ipv4Addr, 4, nn::socket::Family::Af_Inet );
    if ( respHosts == nullptr )
    {
        NN_LOG( "nn::socket::GetHostByAddr() Failed with: errno: %d, h_errno: %d, hstrerror: %s\n",
                 nn::socket::GetLastError(), *(nn::socket::GetHError() ),
                 nn::socket::HStrError(  *(nn::socket::GetHError() ) ) );
        goto out;
    }
    else
    {
        NN_LOG( "Host name       : [%s]\n", respHosts->h_name );
        NN_LOG( "Address Type    : [%d]\n", respHosts->h_addrtype );
        NN_LOG( "Len of Addr     : [%d]\n", respHosts->h_length );

        for(idx = 0; respHosts->h_aliases[idx] != NULL; idx++)
        {

           NN_LOG( "Alias: [%s]\n", respHosts->h_aliases[idx] );
        }

        addr_list = (nn::socket::InAddr **) respHosts->h_addr_list;
        for(idx = 0; addr_list[idx] != NULL; idx++)
        {

           NN_LOG( "IP Address: [%s]\n", nn::socket::InetNtoa( (*addr_list[idx] ) ) );
        }

        NN_LOG( "There are a total of [%d] IPv4 Addresses\n", idx );
    }

    return( true );

out:

    return( false );
}


static bool
TeardownTesting()
{
    bool    isSuccess = true;

    ////////////////////
    ////  Stop Testing
    ////////////////////

    ERROR_IF(!NATF::API::TestTeardown(), "TestTeardown failed.");

out:

    ////////////////////
    ////  Print Test Counts
    ////////////////////

    PRINT_TEST_COUNTS;

    EXPECT_EQ( isSuccess, true );

    NN_LOG( "Out\n\n" );

    return( true );
}


TEST(ApiUnit,Win_GetHErrno_Initialize)
{
    InitializeTesting();
}


TEST(ApiUnit,Win_GetHErrno_GHBN)
{
    bool rval = false, isSuccess = false;

    ///////////////
    // Good DNS Request
    ///////////////

    NN_LOG( "Query: [GetHostByName][www.nintendo.com]\n" );
    rval = CallGetHostByName( "www.nintendo.com" );
    ERROR_IF_AND_COUNT( rval == false, "GHBN - Received a failed DNS Response, but should have succeeded!  errno: %d",
                                                                   *nn::socket::GetHError() );

    NN_LOG( "Got GHBN h_errno: %d\n", *nn::socket::GetHError() );
    NN_LOG( "Got GHBN Str: %s\n", nn::socket::HStrError(  *(nn::socket::GetHError() ) ) );

    ///////////////
    // Failed DNS Request
    ///////////////

    NN_LOG( "Query: [GetHostByName][123456789.111]\n" );
    rval = CallGetHostByName( "123456789.111" );
    ERROR_IF_AND_COUNT( rval == true, "GHBN - Received an Error DNS Response, but indicates response succeeded!" );
    NN_LOG( "Got GHBN h_errno: %d\n", *nn::socket::GetHError() );
    NN_LOG( "Got GHBN Str: %s\n", nn::socket::HStrError(  *(nn::socket::GetHError() ) ) );

out:

    return;
}


TEST(ApiUnit,Win_GetHErrno_GHBA)
{
    bool rval = false, isSuccess = false;

    ///////////////
    // Good DNS Request
    ///////////////

    NN_LOG( "Query: [GetHostByName][www.nintendo.com]\n" );
    rval = CallGetHostByAddr( "205.166.76.26" );
    ERROR_IF_AND_COUNT( rval == false, "GHBN - Received a failed DNS Response, but should have succeeded!  errno: %d",
                                                                   *nn::socket::GetHError() );

    NN_LOG( "Got GHBN h_errno: %d\n", *nn::socket::GetHError() );
    NN_LOG( "Got GHBN Str: %s\n", nn::socket::HStrError(  *(nn::socket::GetHError() ) ) );

    ///////////////
    // Failed DNS Request
    ///////////////

    NN_LOG( "Query: [GetHostByAddr][255.255.255.255] Simple\n" );
    rval = CallGetHostByAddr( "255.255.255.255" );
    ERROR_IF_AND_COUNT( rval == true, "GHBA - Received an Error DNS Response, but indicates response succeeded!" );
    NN_LOG( "Got GHBA h_errno: %d\n", *nn::socket::GetHError() );
    NN_LOG( "Got GHBA h_Str: %s\n", nn::socket::HStrError(  *(nn::socket::GetHError() ) ) );
out:

    return;
}


TEST(ApiUnit,Win_GetHErrno_Teardown)
{
    TeardownTesting();
}

}}  // Namespace: NATF::API
