﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

////////////////////////////////////////////////////////////////
// DEFAULT: DISABLED

//#define ENABLE_FAILING_TESTS

#include "testNet_ApiCommon.h"
#include "Unit/testNet_ApiUnitCommon.h"
#include <nn/socket.h>
#include <nn/nn_Log.h>


namespace NATF {
namespace API {

NN_ALIGNAS(4096) uint8_t g_GetAddrInfoSimpleSocketMemoryPoolBuffer[nn::socket::DefaultSocketMemoryPoolSize];

bool TestGaiSimple(const char* host, const char* service)
{
    int rc = -1;

    nn::socket::AddrInfo    hints = { };
    nn::socket::AddrInfo *  res = nullptr;
    int                     sockfd = -1;
    nn::socket::Errno       errorNumber = nn::socket::Errno::ESuccess;
    nn::Result              result;

    memset(&hints, 0, sizeof(hints));
    hints.ai_family = nn::socket::Family::Af_Inet;
    hints.ai_socktype = nn::socket::Type::Sock_Dgram;
    hints.ai_flags = nn::socket::AddrInfoFlag::Ai_Passive;

    result = nn::socket::Initialize(g_GetAddrInfoSimpleSocketMemoryPoolBuffer,
                                    nn::socket::DefaultSocketMemoryPoolSize,
                                    nn::socket::MinSocketAllocatorSize,
                                    nn::socket::DefaultConcurrencyLimit);

    if( result.IsFailure() )
    {
        NN_LOG("Error: nn::socket::Initialize() failed. Err Desc: %d\n", result.GetDescription());
        goto bail;
    }
    else if ( nn::socket::AiErrno::EAi_Success != nn::socket::GetAddrInfo(host, service, &hints, &res))
    {
        rc = -1;
        errorNumber = nn::socket::GetLastError();
        NN_LOG("GetAddrInfo: %d, errno: %d\n", rc, errorNumber);
        goto bail;
    }
    else if (-1 == (sockfd = nn::socket::Socket(res->ai_family, res->ai_socktype, res->ai_protocol)))
    {
        rc = -1;
        errorNumber = nn::socket::GetLastError();
        NN_LOG("GetAddrInfo: %d, errno: %d\n", rc, errorNumber);
        goto bail;
    };

    rc = 0;

bail:
    if ( -1 != sockfd )
    {
        nn::socket::Close(sockfd);
        sockfd = -1;
    };

    if ( NULL != res)
    {
        nn::socket::FreeAddrInfo(res);
        res = NULL;
    };

    if (result.IsSuccess())
    {
        result = nn::socket::Finalize();
        if( result.IsFailure() )
        {
            NN_LOG("Error: nn::socket::Finalize() failed. Err Desc: %d\n", result.GetDescription());
            rc = -1;
        };
    };

    return rc == 0;
}

TEST(TestGetAddrInfoSimple, WithNullNodename)
{
    TestGaiSimple(NULL, "8080");
}

TEST(TestGetAddrInfoSimple, WithLocalhostNodename)
{
    TestGaiSimple("127.0.0.1", "8080");
}

}} // NATF::API
