﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "Tests/TcpUdpNetworkTest.h"

#include "Utils/CommandLineParser.h"

namespace NATF {
namespace Tests {

    // Constructor
    TcpUdpNetwork::TcpUdpNetwork(const char* pTestName, const nn::util::Uuid& netProfile, uint32_t timeoutMs, const char* appTypeName, const char* ipAddr, uint32_t portNumber, const char* protocolTypeName, uint32_t durationSec, const char* xferPattern) NN_NOEXCEPT :
        BaseTest(pTestName, false, Utils::InitApiFlags::InitApiFlags_Nifm | Utils::InitApiFlags::InitApiFlags_Network | Utils::InitApiFlags::InitApiFlags_Socket, netProfile),
        m_pNode(nullptr),
        m_timeoutMs(timeoutMs),
        m_portNumber(portNumber),
        m_durationSec(durationSec),
        m_xferPattern(nullptr)
    {
        NETTEST_COPY_BUFFER_STRING_ARRAY(m_appTypeName, appTypeName);
        NETTEST_COPY_BUFFER_STRING_ARRAY(m_ipAddr, ipAddr);
        NETTEST_COPY_BUFFER_STRING_ARRAY(m_protocolTypeName, protocolTypeName);
        if( nullptr != xferPattern )
        {
            m_xferPattern = (char*)malloc(Modules::SoTestDataXfer::MaxBufSize);
            NETTEST_COPY_BUFFER_BYTES_POINTER(m_xferPattern, xferPattern, Modules::SoTestDataXfer::MaxBufSize);
        }
    }

    // Destructor
    TcpUdpNetwork::~TcpUdpNetwork() NN_NOEXCEPT
    {
        if( nullptr != m_pNode )
        {
            delete(m_pNode);
            m_pNode = nullptr;
        }
        if( nullptr != m_xferPattern )
        {
            free(m_xferPattern);
            m_xferPattern = nullptr;
        }
    }

    // Cleanup
    bool TcpUdpNetwork::Cleanup() NN_NOEXCEPT
    {
        if( nullptr != m_pNode )
        {
            delete m_pNode;
            m_pNode = nullptr;
        }
        if( nullptr != m_xferPattern )
        {
            free(m_xferPattern);
            m_xferPattern = nullptr;
        }
        return true;
    }

    // Config
    bool TcpUdpNetwork::Config() NN_NOEXCEPT
    {
        TestThread* pThread1 = CreateTestThread("Thread_1", m_timeoutMs);
        if( nullptr == pThread1 )
        {
            return false;
        }

        m_pNode = Modules::SoTestDataXfer::CreateTestNode(pThread1,
            m_appTypeName, m_ipAddr, m_portNumber, m_protocolTypeName,
            m_durationSec, m_xferPattern);
        if( nullptr == m_pNode )
        {
            LogError(" * Failed to allocate node module!\n\n");
            return false;
        }

        pThread1->AddModule(*m_pNode);

        return true;
    }

} // namespace Tests
} // namespace NATF
