﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "Modules/SoHttpDownloadModule.h"

namespace NATF {
namespace Tests {

    class SoHttpDownloadMulti : public BaseTest
    {
        NN_DISALLOW_COPY(SoHttpDownloadMulti);

    public:
        SoHttpDownloadMulti(const char* pTestName, const nn::util::Uuid& netProfile, uint32_t timeoutMs, uint32_t connectionCount, const char* pIp, uint16_t portNum, const char* pResource, const MD5Hash::Result& hashResult, bool useSelect, bool doInit, bool doNnLinger) NN_NOEXCEPT;
        virtual ~SoHttpDownloadMulti() NN_NOEXCEPT NN_OVERRIDE;

        static const Utils::InitApiFlags InitFlags;
        static const uint32_t MaxIpNameLen = 16;
        static const uint32_t MaxResourceLen = 128;

    private:
        virtual bool Cleanup() NN_NOEXCEPT NN_OVERRIDE;
        virtual bool Config() NN_NOEXCEPT NN_OVERRIDE;

        bool AllocateModules() NN_NOEXCEPT;
        void FreeModules() NN_NOEXCEPT;

        const uint32_t m_connectionCount;
        Modules::SoHttpDownload* m_pModules;
        MD5Hash::Result m_expectedHash;

        char m_pIp[MaxIpNameLen];
        char m_pResource[MaxResourceLen];

        const uint16_t m_portNum;
        const uint32_t m_timeoutMs;
        bool m_useSelect;
        bool m_DoNnLinger;
    };

} // namespace Tests
} // namespace NATF
