﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "natf.h"
#include "Utils/md5.h"
#include <nn/ssl/ssl_Connection.h> // For nn::ssl::Connection::VerifyOption

namespace NATF {
namespace Modules {

class SslAbuse : public BaseModule
{
    NN_DISALLOW_COPY(SslAbuse);

public:
    SslAbuse(const char* pHostName, unsigned short port, const char* pCertParthRoot) NN_NOEXCEPT;
    virtual ~SslAbuse() NN_NOEXCEPT override {}

    virtual bool Run() NN_NOEXCEPT override;
    virtual const char* GetName() const NN_NOEXCEPT override;

    static const uint32_t MaxIpStrLen  = 16;
    static const uint32_t HeaderBufLen = 2 * 1024;

private:
    const char* m_pHostName;
    unsigned short m_port;

    const char* m_pServerCertPath;
    nn::ssl::Context* m_pSslContext;

    struct HeaderData
    {
        HeaderData();

        bool isHeaderComplete;
        bool isLastNewLine;
        int contentLength;
        int httpResponse;
        char pHeaderBuf[HeaderBufLen];
        uint32_t headerPos;
    };

    bool NormalHandshake(nn::ssl::Connection* pSslConnection, nn::Result expectedHandshakeResult, nn::Result expectedVerifyResult) NN_NOEXCEPT;
    bool CertChainHandshake(nn::ssl::Connection* pSslConnection) NN_NOEXCEPT;
    bool ConfigSslContext(nn::ssl::Context* pOutContext) const NN_NOEXCEPT;
    bool ConfigSslConnection(nn::ssl::Connection* pOutConnection, nn::ssl::Context* pInContext, int socketFd, bool isBlocking, const char* pHostName, char* pServerCertBuff, uint32_t serverCertBuffLen, nn::ssl::Connection::VerifyOption verifyOption, nn::ssl::Connection::SessionCacheMode cacheMode, bool isGetCertChainEnable) const NN_NOEXCEPT;

    bool Download(nn::ssl::Context* pContext, uint32_t downloadCount, bool isBlocking, const char* pHostName, unsigned short serverPort, const char* pResource, nn::ssl::Connection::SessionCacheMode cacheMode, nn::ssl::Connection::VerifyOption verifyOption, bool isGetCertChainEnable, bool isDoPostEnabled) NN_NOEXCEPT;
    bool ReceiveResponse(nn::ssl::Connection& sslConnection, bool isBlocking, uint32_t readChunk, int expectedHttpResponse) NN_NOEXCEPT;
    char* ParseHeader(char* pBuffer, unsigned bufSize, HeaderData& headerData) NN_NOEXCEPT;
    bool ConnectToServer(int socketFd, const char* pHostName, unsigned short portNum) const NN_NOEXCEPT;
    int CreateSocketWithOptions() const NN_NOEXCEPT;
    bool SendHttpRequest(nn::ssl::Connection& sslConnection, const char* pResource, const char* pHostName) const NN_NOEXCEPT;
    bool SendHttpPost(nn::ssl::Connection& sslConnection, const char* pResource, const char* pHostName, int32_t dataLen) const NN_NOEXCEPT;
    void InetNtoP(int32_t ipAddr, char pOutIp[MaxIpStrLen]) const;

    bool ReadCertsIntoBuffers() const NN_NOEXCEPT;
    bool ImportCertsOnSameThread() const NN_NOEXCEPT;
    bool ImportCertsOnDiffThreads() const NN_NOEXCEPT;
    bool DownloadOnDiffThreads(bool isGetCertChainEnabled, nn::ssl::Connection::VerifyOption verifyOption, bool isUseLocalServerEnabled, bool isPostEnabled) NN_NOEXCEPT;
    bool CreateConnections(uint32_t connectionCount) const NN_NOEXCEPT;
    bool RepeatDownload(uint32_t downloadCount, bool isDoPostEnabled) NN_NOEXCEPT;
    bool CreateDestroyContext(uint32_t loopCount) NN_NOEXCEPT;
    bool NonBlockDownloadWithTicketCache(uint32_t downloadCount) NN_NOEXCEPT;
    bool BlockingDownloadWithIDCache(uint32_t downloadCount) NN_NOEXCEPT;
    bool HandshakeWithDiffHosts(uint32_t handshakeCount) NN_NOEXCEPT;
    bool HandshakeWithServerCertDetailsBlocking(uint32_t handshakeCount) NN_NOEXCEPT;
    bool HandshakeWithServerCertDetailsNonBlocking(uint32_t handshakeCount) NN_NOEXCEPT;
    bool HandshakeWithServerCertDetailsSessionId(uint32_t handshakeCount) NN_NOEXCEPT;
    bool HandshakeWithServerCertDetailsSessionTicket(uint32_t handshakeCount) NN_NOEXCEPT;
    bool ImportChainAndCrl(nn::ssl::Context* pSslContext, uint32_t chainIndex) NN_NOEXCEPT;
    bool ImportCrl(uint32_t importCount, uint32_t chainIndex, uint32_t chainCount, bool doHandshake) NN_NOEXCEPT;
    bool ImportCrlOnDiffCtx(uint32_t importCount, bool doHandshake) NN_NOEXCEPT;
    bool ImportCrlOnDiffThreads(uint32_t loopCount) NN_NOEXCEPT;

    static void ImportThreadFn(void* pParam) NN_NOEXCEPT;
    static void DownloadThreadFn(void* pParam) NN_NOEXCEPT;
    static void ImportCrlThreadFn(void* pParam) NN_NOEXCEPT;
};

}
}
