﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/TargetConfigs/build_Base.h>
#include <cstdio>
#include <nn/nn_Log.h>

#ifdef NN_BUILD_CONFIG_OS_WIN32
#define NN_NETTEST_LOG(...) NN_LOG("[NetTest] "##__VA_ARGS__)
#define NATF_LOG(...) NN_LOG("[NATF]"##__VA_ARGS__)
#define NETTEST_SNPRINTF _snprintf
#else
#define NN_NETTEST_LOG(format, ...) NN_LOG("[NetTest] " format, ##__VA_ARGS__)
#define NATF_LOG(format, ...) NN_LOG("[NATF]" format, ##__VA_ARGS__)
#define NETTEST_SNPRINTF snprintf
#endif

#define NETTEST_ABORT()         \
do {                            \
    NN_NETTEST_LOG(" ******** Program Aborted! ********\n File: %s\n Line: %d\n Function: %s\n\n", __FILE__, __LINE__, __FUNCTION__); \
    NetTest::SleepMs(1000);        \
    int _CRASH_IT_ = 0;         \
    **(int**)(&_CRASH_IT_) = 0; \
} while( NN_STATIC_CONDITION(false) )
