﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

class TestThread
{
    NN_DISALLOW_COPY(TestThread);

public:
    enum ExitReason
    {
        ExitReason_Error,
        ExitReason_Disconnected,
        ExitReason_FinishedSend,
        ExitReason_ReceivedExit
    };
    enum Type
    {
        Type_Server,
        Type_Client,
        Type_ServerExempt,
        Type_ClientExempt,
    };
    typedef void ThreadFunc(void* pParam);

    static const unsigned StackSize = 1024 * 64;
    static const unsigned StackAlign = 4096;

    static TestThread * CreateTestThread(ThreadFunc * pFunc) NN_NOEXCEPT;
    static void FreeTestThread(TestThread * pTestThread) NN_NOEXCEPT;

    void InitializeMultiWaitHolderWithThread(nn::os::MultiWaitHolderType * holder, uint32_t usage) NN_NOEXCEPT;

    void Start() NN_NOEXCEPT;

    void SetClientAddr(nn::socket::InAddr addr) NN_NOEXCEPT;
    nn::socket::InAddr GetClientAddr() NN_NOEXCEPT;

    void SetServerAddr(nn::socket::InAddr addr) NN_NOEXCEPT;
    nn::socket::InAddr GetServerAddr() NN_NOEXCEPT;

    void SetServerPort(unsigned short port) NN_NOEXCEPT;
    unsigned short GetServerPort() NN_NOEXCEPT;

    void SetReady(bool ready) NN_NOEXCEPT;
    bool IsReady() NN_NOEXCEPT;

    void SetExitReason(ExitReason reason) NN_NOEXCEPT;
    ExitReason GetExitReason() NN_NOEXCEPT;
    const char * GetExitReasonString() NN_NOEXCEPT;

    void SetExempt(bool reason) NN_NOEXCEPT;
    bool GetExempt() NN_NOEXCEPT;

private:

    TestThread() NN_NOEXCEPT;
    ~TestThread() NN_NOEXCEPT;

    unsigned char m_pStack[StackSize];
    unsigned char* m_pUnalignedBuf;

    nn::socket::InAddr m_clientAddr;
    nn::socket::InAddr m_serverAddr;
    unsigned short m_serverPort;
    bool m_ready;
    bool m_exempt;

    ExitReason m_reason;

    nn::os::ThreadType m_thread;
    nn::os::MutexType m_mutex;

};

