﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/os.h>

#include <nn/ndd.h>
#include "../Common/testNdd_Common.h"

#define TEST_LOG(format, ...) NN_LOG("[testNdd_DummyData]" format, ##__VA_ARGS__)

enum TestMode
{
    TestMode_DynamicDataId, //DataIdは常に更新
    TestMode_StaticDataId,  //DataIdは固定
};

nn::ndd::SendDataDescription GenerateSendData(TestMode testMode, int seed)
{
    nn::ndd::SendDataDescription sdd;

    if(testMode == TestMode_DynamicDataId)
    {
        *reinterpret_cast<uint64_t*>(&sdd.dataId.raw[0]) = static_cast<uint64_t>(seed);
    }
    else if(testMode == TestMode_StaticDataId)
    {
        *reinterpret_cast<uint64_t*>(&sdd.dataId.raw[0]) = static_cast<uint64_t>(1);
    }
    else
    {
        NN_ABORT("faulty design\n");
    }

    static PayloadUtil payloadUtil;
    payloadUtil.Generate(seed, nn::ndd::SendDataSizeMax);
    memcpy(&sdd.data[0], payloadUtil.GetPtr(), payloadUtil.GetSize());
    sdd.dataSize = payloadUtil.GetSize();

    return sdd;
}

extern "C" void nnMain()
{
    nn::ndd::Initialize();

    for(int i=0;;++i)
    {
        TEST_LOG("seed = %d\n",i);
        nn::ndd::AddSendData(GenerateSendData(TestMode_DynamicDataId, i));
        nn::os::SleepThread(nn::TimeSpan::FromSeconds(1));
    }
}
