$ErrorActionPreference = "stop"

function Append($path, $data) {
	$file = New-Object System.IO.FileStream $path, Append;
	$file.Write($data, 0, $data.Length);
	$file.Dispose();
}

function GetFileSize($r, $min, $max) {
	$base = 2.0
	return [long] ((([System.Math]::Pow($base, $r.NextDouble()) - 1.0) / ($base - 1.0)) * [double] ($max - $min) + [double] $min);
}

if (Test-Path Env:TEMP) {
    $source = [System.Environment]::ExpandEnvironmentVariables("%TEMP%\source.bin")
    $destination = [System.Environment]::ExpandEnvironmentVariables("%TEMP%\expected.bin")
    $patch = [System.Environment]::ExpandEnvironmentVariables("%TEMP%\patch.bdiff")
} else {
    if (Test-Path Env:TMP) {
        $source = [System.Environment]::ExpandEnvironmentVariables("%TMP%\source.bin")
        $destination = [System.Environment]::ExpandEnvironmentVariables("%TMP%\expected.bin")
        $patch = [System.Environment]::ExpandEnvironmentVariables("%TMP%\patch.bdiff")
    } else {
        $source = "C:\Windows\Temp\source.bin"
        $destination = "C:\Windows\Temp\expected.bin"
        $patch = "C:\Windows\Temp\patch.bdiff"
    }
}

if ([System.IO.File]::Exists($source)) {
	[System.IO.File]::Delete($source)
}
if ([System.IO.File]::Exists($destination)) {
	[System.IO.File]::Delete($destination)
}

$seed = Get-Random
$msg = "Seed is " + $seed
echo $msg
$rand = New-Object System.Random $seed

$buffer_size = 32 * 1024 * 1024
$size_min = [long] 32 * 1024 * 1024
$size_max = [long] 4 * 1024 * 1024 * 1024
# $size = [long] ([System.Math]::Abs(([long] $rand.Next(0, 0x7FFFFFFF) -shl 32) -bor [long] $rand.Next([int]::MinValue, [int]::MaxValue)) % ($size_max - $size_min + 1) + $size_min)
$size = GetFileSize $rand $size_min $size_max

$msg = "File Size " + [int]($size / 1024 / 1024) + " MiB"
echo $msg

$size_change_min = - [int] ($size / 100)
$size_change_max= [int] ($size / 100)
$file_size_change = $rand.Next($size_change_min, $size_change_max)
$new_size = [long] ($size + $file_size_change)

$offset = [long] 0
while ($offset -lt $size -or $offset -lt $new_size) {
	if ($offset -lt $size) {
		$destination_size = [System.Math]::Min($size - $offset, $buffer_size)

		$src = New-Object byte[] $destination_size
		$rand.NextBytes($src)
		Append "$source" $src
	}

	if ($offset -lt $new_size) {
		$destination_new_size = [System.Math]::Min($new_size - $offset, $buffer_size)
		$src2 = New-Object byte[] $destination_new_size

		if ($offset -lt $size) {
			$copy_size = [System.Math]::Min($destination_size, $destination_new_size)
			[System.Array]::Copy($src, 0, $src2, 0, $copy_size)

			$try = [int] ($copy_size / 10000)
			for ($i = 0; $i -lt $try; ++$i) {
				$index = $rand.Next(0, $copy_size - 1)
				$src2[$index] = $rand.Next(0, 255)
			}

			if ($copy_size -lt $destination_new_size) {
				$src3 = New-Object byte[] ($destination_new_size - $copy_size)
				$rand.NextBytes($src3)
				[System.Array]::Copy($src3, 0, $src2, $copy_size, $src3.Length)
			}

		} else {
			$rand.NextBytes($src2)
		}

		Append "$destination" $src2
	}

	$offset += $buffer_size
}

$auth = [System.Environment]::ExpandEnvironmentVariables("%NINTENDO_SDK_ROOT%/Tools/CommandLineTools/AuthoringTool/AuthoringTool.exe")
& $auth bdiff --source $source --destination $destination --command-size-max 65536 -o $patch

